<!DOCTYPE html>
<html lang="de">
<head>
   <meta charset="utf-8">
   <title>Max in Australien</title>
   <!-- Die "australische" Hintergrundfarbe ist #ffee00.
        Die CSS-Klasse li wird mit einer etwas kleineren Schrift eingestellt.
        Sie wird in der linken Spalte für die Zeitangaben benutzt.
        Die Inhalte der Zellen werden jeweils am oberen Rand der Zelle ausgerichtet. -->
   <style type="text/css">
      body,td   {font-family:Verdana; font-size:10pt; background-color:#ffee00; color:#00008b}
      .li       {font-size:8pt}
      td        {vertical-align:top;}
   </style>
</head>

<!-- Jeder Eintrag ist mit zwei Zeitinformationen versehen.
     Dabei handelt es sich um die Zeit, zu der der jeweilige Eintrag vorgenommen wird und nach der die Einträge absteigend sortiert werden.
     Einerseits wird die Ortszeit des Betrachters in MEZ (mitteleuropäische Zeit) dargestellt,
     und andererseits können Sie die Ortszeit des Betreibers ablesen: in AWST (Australian Western Standard Time).
     In unserem Beispiel befindet sich der Betreiber Max in Westaustralien. -->

<body>
<p><b>Max in Australien</b></p>
<table>

<?php
   /* Die Ergebnisse der Datenbankabfrage sind absteigend nach Zeit sortiert. */
   $con = new mysqli("localhost", "root", "", "blog");
   $sql = "SELECT * FROM blogdaten ORDER BY zeit DESC";
   $res = $con->execute_query($sql);

   while($dsatz = $res->fetch_assoc())
   {
      /* Der Eintrag im Feld "zeit" wird gelesen und in eine Zeitvariable umgewandelt.
         Damit lässt sich der Wert für die um sieben Stunden verschobene westaustralische Ortszeit ermitteln. */
      $z = $dsatz["zeit"];
      $zeit = mktime(mb_substr($z,11,2), mb_substr($z,14,2), mb_substr($z,17,2), mb_substr($z,5,2), mb_substr($z,8,2), mb_substr($z,0,4));
      $awst = strtotime("+7 hour", $zeit);

      /* Beide Zeitangaben werden in die linke Spalte geschrieben. */
      echo "<tr>";
      echo "<td class='li'>" . date("d.m.y H:i", $zeit) . " MEZ<br>" . date("d.m.y H:i", $awst) . " AWST</td>";

      /* In der rechten Spalte wird der eigentliche Inhalt des Blogs ausgegeben,
         entweder der Text oder das Bild, abhängig vom Eintrag im Feld "art". */
      if($dsatz["art"] == 1)
         echo "<td><img src='" . $dsatz["text"] . "' alt='[Bild]'></td>";
      else
         echo "<td>" . $dsatz["text"] . "</td>";
      echo "</tr>";
   }
   $res->close();
   $con->close();
?>

</table>

<!-- Es folgt noch eine Erklärung zu den Zeitzonen, ebenfalls in kleinerer Schrift dank der CSS-Klasse li. -->
<p class="li">MEZ = Mitteleurop. Zeit, AWST = Australian Western Standard Time</p>
</body>
</html>
