<!DOCTYPE html>
<html lang="de">
<head>
   <meta charset="utf-8">
   <title>Blog, Datenbank neu</title>
</head>
<body>
<?php
   $con = new mysqli("localhost", "root", "");
   $sql = "CREATE DATABASE IF NOT EXISTS blog";
   $con->execute_query($sql);
   $con->select_db("blog");

   /* Auf dem Feld "id" liegt ein Primärschlüssel, außerdem verfügt es über die Eigenschaft AUTO_INCREMENT (kurz: A_I).
      Damit erhalten die Einträge im Feld "id" eine eindeutige Nummer, die immer um 1 höher liegt als die bisherige größte Nummer.
      Das Feld "zeit" ist vom Typ TIMESTAMP. Bei jeder Erzeugung eines Datensatzes wird hier die aktuelle Systemzeit eingetragen.
      Im Feld "art" steht entweder eine 0 für einen Texteintrag oder eine 1 für einen Bildeintrag.
      Im Feld "text" steht entweder der eingetragene Text oder der Name der Bilddatei. */
   $sql = "CREATE TABLE IF NOT EXISTS blogdaten (
      id INT(11) NOT NULL AUTO_INCREMENT,
      zeit TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
      art INT(11) NOT NULL,
      text VARCHAR(1000) DEFAULT NULL,
      PRIMARY KEY (id)
      ) ENGINE=InnoDB DEFAULT CHARSET=UTF8";
   $con->execute_query($sql);
   
   $sql = "INSERT INTO blogdaten (zeit, art, text) VALUES
      ('2022-06-25 05:53:04', 0, 'Das ist der erste Text'),
      ('2022-06-25 05:53:35', 0, 'Das ist der zweite Text'),
      ('2022-06-25 05:59:30', 1, 'blog_20220625055930.jpg')";
   $con->execute_query($sql);

   $con->close();
?>
</body>
</html>
