<!DOCTYPE html>
<html lang="de">
<head>
   <meta charset="utf-8">
   <title>Max in Australien, Eingabe</title>
   <style type="text/css">
      body,td {font-family:Verdana; font-size:10pt; background-color:#ffee00; color:#00008b}
      .li     {font-size:8pt}
   </style>
<?php
   /* Abfrage, ob die Datei mit oder ohne gesendete Daten aufgerufen wird. */
   if(isset($_POST["gesendet"]))
   {
      $con = new mysqli("localhost", "root", "", "blog");
    
      /* Handelt es sich bei den Daten um einen Text,
         wird dieser mithilfe eines Prepared Statements und der SQL-Anweisung INSERT in die Datenbank eingefügt. */
      if($_POST["art"] == 0)
      {
         $sql = "INSERT INTO blogdaten (art, text) VALUES (0, ?)";
         $con->execute_query($sql, [$_POST["text"]]);
      }

      /* Handelt es sich bei den Daten um einen Bild,
         wird es auf eine Breite (bzw. Höhe) von 320 Pixeln verkleinert. */
      else
      {
         /* Der Name der hochgeladenen Datei wird mithilfe des superglobalen Felds $_FILES ermittelt.
            Die Endung des Dateinamens wird festgestellt.
            Handelt es sich um eine Datei mit der Endung "jpg", kann sie hochgeladen werden. */
         $fn = $_FILES["upfile"]["name"]; echo $fn;
         $fn_teile = mb_split("\.", $fn);
         $fn_endung = $fn_teile[count($fn_teile) - 1];
         if(mb_strtolower($fn_endung) == "jpg")
         {
            /* Der neue Name der Bilddatei wird festgelegt. Er enthält das Datum und die Zeit, zu der der Eintrag vorgenommen wird.
               Damit hat jede Bilddatei einen eindeutigen Namen, unabhängig von dem Namen, der vom Aufnahmegerät vergeben wird. */
            $fn = "blog_" . date("YmdHis") . "." . $fn_endung;

            /* Die Datei wird aus dem temporären Serververzeichnis in das Anwendungsverzeichnis auf dem Server kopiert.
               Der neue Name wird in der Datenbank abgelegt,
               damit das Bild für den Betrachter auf der Seite blog.php dargestellt werden kann. */
            copy($_FILES["upfile"]["tmp_name"], $fn);
            $sql = "INSERT INTO blogdaten (art, text) VALUES (1, '$fn')";
            $con->execute_query($sql);

            /* Falls Sie das Bild in Originalgröße darstellen wollten, müssten keine weiteren Aktionen erfolgen.
               Allerdings soll es auf eine Breite (beziehungsweise Höhe) von 320 Pixeln verkleinert werden.
               Dazu wird zunächst die aktuelle Größe des Bildes mithilfe der Funktion getimagesize() festgestellt.
               Diese Funktion liefert ein Feld mit Bildinformationen. */
            $info = getimagesize($fn);
            $width_alt = $info[0];
            $height_alt = $info[1];

            /* Abhängig davon, ob das Bild im Querformat oder im Hochformat aufgenommen wurde,
               wird die Größe des neuen Bildes festgelegt.
               Handelt es sich zum Beispiel um ein Bild im Querformat, ist die Breite größer als die Höhe.
               Die neue Breite wird auf 320 Pixel festgelegt. Die neue Höhe wird passend dazu aus den alten Daten ermittelt. */
            if($width_alt > $height_alt)
            {
               $width_neu = 320;
               $height_neu = ceil($height_alt * $width_neu / $width_alt);
            }
            else
            {
               $height_neu = 240;
               $width_neu = ceil($width_alt * $height_neu / $height_alt);
            }

            /* Es werden zwei Grafikobjekte erschaffen.
               Das Grafikobjekt für das alte Bild basiert auf der alten Bilddatei und
                  wird mithilfe der Funktion imagecreatefromjpeg() erzeugt.
               Das Grafikobjekt für das neue Bild ist zunächst schwarz und
                  wird mithilfe der Funktion imagecreatetruecolor() in der gewünschten neuen Größe erzeugt. */
            $im_alt = imagecreatefromjpeg($fn);
            $im_neu = imagecreatetruecolor($width_neu, $height_neu);

            /* Der entscheidende Schritt wird mithilfe der Funktion imagecopyresampled() durchgeführt.
               Damit wird das alte Grafikobjekt bei gleichzeitiger Größenänderung in das neue Grafikobjekt überführt.
               Dabei werden die Bildpixel gleichmäßig interpoliert. Die Funktion benötigt insgesamt zehn Parameter:
                  die Grafikobjekte, die Breite, die Höhe und die Koordinaten, und zwar jeweils des alten und des neuen Bildes. */
            imagecopyresampled($im_neu, $im_alt, 0, 0, 0, 0, $width_neu, $height_neu, $width_alt, $height_alt);

            /* Die neue Bilddatei wird gespeichert, und die beiden nicht mehr benötigten Grafikobjekte werden zerstört. */
            imagejpeg($im_neu, $fn);
            imagedestroy($im_alt);
            imagedestroy($im_neu);
         }
         else
            echo "<p>Bild muss vom Typ JPG sein!</p>";

         $con->close();
      }
   }
?>
</head>

<body>
<!-- Es gibt zwei Formulare, die beide die gleiche Datei aufrufen und
        beide eine Submit-Schaltfläche mit dem Namen "gesendet" besitzen.
     Beim Laden der Seite wird bemerkt, ob sie mit oder ohne gesendete Daten aufgerufen wird. -->
<p><b>Max in Australien, Eingabe</b></p>

<!-- Das erste Formular enthält eine Textarea zur Eingabe eines längeren Textes mit dem Namen "text". -->
<form action="blog_eingabe.php" method="post">
   <input type="hidden" name="art" value="0">
   <p>Eingabe und Absenden des Texts (max. 1000 Zeichen):</p>
   <p><textarea name="text" rows="5" cols="80"></textarea></p>
   <p><input type="submit" name="gesendet" value="Senden">
   <input type="reset" value="Leeren"></p>
</form>

<p><b>oder</b></p>

<!-- Das zweite Formular enthält ein Element für den Datei-Upload mit dem Namen "upfile". -->
<form enctype="multipart/form-data" action="blog_eingabe.php" method="post">
   <input type="hidden" name="art" value="1">
   <p>Auswahl und Absenden des Bilds:</p>
   <p><input name="upfile" type="file"></p>
   <p><input type="submit" name="gesendet" value="Senden">
   <input type="reset" value="Leeren"></p>
</form>

</body>
</html>
