<!DOCTYPE html>
<html lang="de">
<head>
   <meta charset="utf-8">
   <title>Chat, Version Datenbank</title>
   <!-- Beide Versionen binden die CSS-Datei chat.css zur einheitlichen Formatierung ein.
        Kommentare siehe dort.   -->
   <link rel="stylesheet" type="text/css" href="chat.css">
</head>

<!-- Zu einem Chat gibt es im Internet viele vorgefertigte Lösungen, die man unmittelbar nutzen kann.
     Hier kommt darauf an, die Anwendung mit den erlernten Mitteln zu entwickeln und die einzelnen Komponenten zu verstehen.
     Mögliche Erweiterungen: am Ende dieser Datei.	 -->

<body>
<?php
/* Speichern eines neuen Beitrags:
   Gibt es keinen Beitrag zum Speichern, wird in diesem Teil nichts ausgeführt. Dies ist beim ersten Aufruf der Seite der Fall.
   Mithilfe eines Prepared Statements und der SQL-Anweisung INSERT werden der (Spitz-)Name des Benutzers und
   sein Beitrag in die Tabelle "daten" der Datenbank "chat" geschrieben.
   Die Tabelle "daten" enthält ein drittes Feld des Typs TIMESTAMP. Darin werden bei Erzeugung (oder Änderung)
   des Datensatzes automatisch das aktuelle Datum und die aktuelle Uhrzeit eingetragen. */
$con = new mysqli("localhost", "root", "", "chat");

if(isset($_POST["beitrag"]))
{
   $sql = "INSERT INTO daten (nick, beitrag) VALUES (?, ?)";
   $con->execute_query($sql, [$_POST["nick"], $_POST["beitrag"]]);
}
?>

<!-- Formular zur Eingabe eines neuen Beitrags:
     Siehe Erläuterung in Datei chat_text.php. -->
<form name="f" action="chat_db.php" method="post">
<table>
   <tr>
     <td>Ihr Name:</td>
     <td><input name="nick"
        <?php
          if(isset($_POST["nick"]))
            echo "value='" . $_POST["nick"] . "'";
        ?>
        size="20"></td>
     <td style="text-align:right;">
        <input type="submit" value="Senden">
     </td>
   </tr>

   <tr>
      <td style="vertical-align:top;">Ihr Beitrag:</td>
      <td colspan="3"><textarea cols="50"
            rows="2" name="beitrag"></textarea></td>
   </tr>
</table>
</form>

<?php
/* Ausgabe der bisherigen Beiträge:
   - Alle Datensätze werden aus der Tabelle "daten" der Datenbank "chat" geholt.
   - Sie werden nach dem Feld "zeit" sortiert, sodass der neueste Beitrag unten steht. */
$sql = "SELECT * FROM daten ORDER BY zeit";
$res = $con->execute_query($sql);

/* Sind Datensätze vorhanden, wird eine dreispaltige Tabelle mit den Überschriften "Zeit", "Name" und "Beitrag" begonnen. */
if($res->num_rows > 0)
{
   echo "<table><tr><td><b>Zeit</b></td><td><b>Name</b></td><td><b>Beitrag</b></td></tr>";

   /* Alle Datensätze werden mithilfe einer while-Schleife und der Methode fetch_assoc() im assoziativen Feld $dsatz gespeichert. */
   while($dsatz = $res->fetch_assoc())
   {
      /* Der automatisch erstellte MySQL-Timestamp im Datenfeld "zeit" wird zerlegt, damit er formatiert ausgegeben werden kann. */
      $z = $dsatz["zeit"];
      $zs = mb_substr($z,8,2) . "." . mb_substr($z,5,2) . "." . mb_substr($z,0,4) . " " . mb_substr($z,11);

      /* Die drei Angaben jedes Datensatzes werden als HTML-Tabellenzeile ausgegeben. */
      echo "<tr><td>$zs</td><td>" . $dsatz["nick"] . "</td><td>" . $dsatz["beitrag"] . "</td></tr>";
   }
   echo "</table>";
}
$res->close();
$con->close();
?>
</body>
</html>

<!-- Das Programm könnte um die folgenden Features erweitert werden:
     - Der Benutzer, der an einem Chat teilnehmen möchte, gelangt zunächst zu einer Login-Seite.
     - Dort meldet er sich mit seinem (Spitz-)Namen und seinem Passwort an und bestimmt, an welcher Chat-Gruppe er teilnehmen möchte.
     - Alle anwesenden Teilnehmer jeder Chat-Gruppe werden angezeigt, sodass man sich einen Überblick darüber verschaffen kann,
          wie gut die jeweilige Chat-Gruppe besucht ist und ob Bekannte dabei sind.
     - Ein neu hinzukommender Benutzer, der noch kein Passwort hat, wird auf eine Seite zur Neuanmeldung verwiesen.
     - Hier trägt er seine persönlichen Daten ein, soweit diese für die Chat-Anmeldung relevant sind.

     Außerdem könnte eine Administrationsseite für einen Moderator erstellt werden. Dieser kann Folgendes:
     - alle Chat-Beiträge sehen
     - eigene Beiträge und Hinweise senden
     - Beiträge, die bestimmte Regeln verletzen, gegebenenfalls löschen
     - Benutzer temporär oder permanent ausschließen
     - Neuanmeldungen bearbeiten und die neuen Benutzer benachrichtigen

     Ausgehend von der Version "Datenbank" wird eine zusätzliche Tabelle für die Benutzer benötigt.
     Hier werden die folgenden Angaben gespeichert: persönliche Daten, Spitzname, Passwort,
        Anwesenheitsvermerk (anwesend, wenn ja, in welchem Chat), Benutzerstatus (neu, normal, gesperrt).
     Die Tabelle "daten" wird um ein Feld "gruppe" erweitert. Bei der Ausgabe werden mit der SQL-Anweisung
        nur die Beiträge aus der betreffenden Gruppe ausgewählt. -->
