<!DOCTYPE html>
<html lang="de">
<head>
   <meta charset="utf-8">
   <title>Chat, Version Textdatei</title>
   <!-- Beide Versionen binden die CSS-Datei chat.css zur einheitlichen Formatierung ein.
        Kommentare siehe dort.   -->
   <link rel="stylesheet" type="text/css" href="chat.css">
</head>

<!-- Zu einem Chat gibt es im Internet viele vorgefertigte Lösungen, die man unmittelbar nutzen kann.
     Hier kommt darauf an, die Anwendung mit den erlernten Mitteln zu entwickeln und die einzelnen Komponenten zu verstehen. -->
	 
<body>
<?php
/* Speichern eines neuen Beitrags:
   - Gibt es keinen Beitrag, wird hier nichts ausgeführt. Dies ist beim ersten Aufruf der Seite der Fall.
   - Das aktuelle Datum und die aktuelle Uhrzeit werden ermittelt und
     zusammen mit dem (Spitz-)Namen des Benutzers und seinem Beitrag an die Datei chat_text.txt angehängt.
   - Diese drei Angaben werden in eine HTML-Tabellenzeile eingebettet,
     sodass die betreffende Zeile beim späteren Lesevorgang unmittelbar ausgegeben werden kann.
   - Damit der Entwickler die Inhalte der Textdatei besser kontrollieren kann, wird am Ende ein Zeilenumbruch in die Datei eingefügt. */
if(isset($_POST["beitrag"]))
{
   $jetzt = date("d.m.Y H:i:s");
   $nick = htmlentities($_POST["nick"]);
   $beitrag = htmlentities($_POST["beitrag"]);
   $inhalt = "<tr><td>$jetzt</td><td>$nick</td><td>$beitrag</td></tr>\n";
   $datei = "chat_text.txt";
   @file_put_contents($datei, $inhalt, FILE_APPEND);
}
?>

<!-- Formular zur Eingabe eines neuen Beitrags:
     - Vom Formular aus wird dieselbe Datei wieder aufgerufen. Nach dem Absenden steht das Eingabefenster also erneut zur Verfügung.
     - Die Formularelemente sind in eine kleine Tabelle eingebettet.
     - In der oberen Tabellenzeile steht das Eingabefeld für den (Spitz-)Namen. Der Benutzer muss seinen Namen nur einmal eintragen.
       Nach dem Absenden sorgt PHP dafür, dass der gleiche Name wieder übernommen wird (value='$nick').
     - Es folgt die Schaltfläche zum Senden eines Beitrags.
     - In der unteren Tabellenzeile nimmt eine Textarea der Größe 50 × 2 die neuen Beiträge auf. -->

<form action="chat_text.php" method="post">
<table>
  <tr>
    <td>Ihr Name:</td>
    <td><input name="nick"
    <?php
      if(isset($nick))
        echo "value='$nick'";
    ?>
    size="20"></td>
    <td style="text-align:right;">
      <input type="submit" value="Senden">
    </td>
  </tr>
  <tr>
    <td style="vertical-align:top;">Ihr Beitrag:</td>
    <td colspan="3"><textarea cols="50"
        rows="2" name="beitrag"></textarea></td>
  </tr>
</table>
</form>

<!-- Ausgabe der bisherigen Beiträge:
     Es wird eine dreispaltige Tabelle mit den Überschriften Zeit, Name und Beitrag begonnen. -->
<table>
  <tr>
    <td><b>Zeit</b></td>
    <td><b>Name</b></td>
    <td><b>Beitrag</b></td>
  </tr>

<?php
/* Der Inhalt der Textdatei chat_text.txt wird vollständig gelesen und ausgegeben.
   Jede Zeile enthält bereits die Formatierungen für eine Zeile einer HTML-Tabelle, siehe Textdatei chat_text.txt. */
   $datei = "chat_text.txt";
   $inhalt = @file_get_contents($datei, $inhalt);
   echo $inhalt;
?>
</table>
</body>
</html>
