<!DOCTYPE html>
<html lang="de">
<head>
   <meta charset="utf-8">
   <title>Verzeichnis-Information</title>
   <style>
      table,td {border:1px solid black;}
   </style>
</head>
<body>
<?php
   $verzeichnis = "D:/xampp/install";
   if(!file_exists($verzeichnis))
      exit("Kein Verzeichnis");
   chdir($verzeichnis);

   echo "<h2>Verzeichnis $verzeichnis</h2>";
   echo "<table>";

   /* Überschrift */
   echo "<td>Name</td>";
   echo "<td>Datei /<br>Verzeichnis</td>";
   echo "<td>Readable /<br>Writeable</td>";
   echo "<td style='text-align:right;'>Größe<br>in Byte</td>";
   echo "<td>Letzte<br>Änderung</td>";

   /* Öffnet Handle */
   $handle = opendir($verzeichnis);

   /* Liest alle Objektnamen */
   while($name = readdir($handle))
   {
      echo "<tr>";
      echo "<td>$name</td>";

      /* Datei oder Verzeichnis? */
      if(is_file($name))
         echo "<td>D</td>";
      else if(is_dir($name))
         echo "<td>V</td>";
      else
         echo "<td>&nbsp;</td>";

      /* Lesbar beziehungsweise schreibbar? */
      echo "<td>";
      if(is_readable($name)) echo "R";
      else echo "-";
      if(is_writeable($name)) echo "W";
      else echo "-";
      echo "</td>";

      /* Zugriffsdaten */
      $info = stat($name);
      echo "<td style='text-align:right;'>" . $info["size"] . "</td>";
      echo "<td>" . date("d.m.y H:i", $info["mtime"]) . "</td>";
      echo "</tr>";
   }

   /* Schließt Handle */
   closedir($handle);
?>

</table>
</body>
</html>
