<!-- Startpunkt der Anwendung -->
<!DOCTYPE html>
<html lang="de">
<head>
   <meta charset="utf-8">
   <title>Datenbanken und Tabellen</title>
   <style>
      table,td {border:1px solid black;}
   </style>
</head>
<body>
<?php
   /* Die Verbindung zum Datenbankserver wird aufgenommen. */
   $con = new mysqli("localhost", "root", "");

   /* Mithilfe der SQL-Anweisung SHOW DATABASES wird eine Abfrage gestartet,
      deren Ergebnis eine Liste aller verfügbaren Datenbanken auf dem Datenbankserver ist. */
   $dbresult = $con->execute_query("SHOW DATABASES");

   /* Es wird ein assoziatives Feld mit den Namen der internen Datenbanken von MySQL und phpMyAdmin erstellt. */
   $intern = array("information_schema" => 1, "mysql" => 2,
      "performance_schema" => 3, "phpmyadmin" => 4, "sys" => 5, "test" => 6);

   /* Die Überschrift wird ausgegeben */
   echo "<h3>MySQL, Struktur und Inhalt der nicht internen Datenbanken</h3>";

   /* Die Liste der Datenbanken wird in einer Schleife durchlaufen. */
   $d = 0;
   while($dbdsatz = $dbresult->fetch_array())
   {
      /* Der Inhalt des ersten Felds jedes Ergebnisdatensatzes ist der Name der aktuellen Datenbank innerhalb der Schleife.
         Dieser wird gespeichert. Handelt es sich um den Namen einer internen Datenbank, wird der Rest der Schleife übersprungen. */
      $dbname = $dbdsatz[0];
      if(isset($intern[$dbname]))
         continue;

      /* Die aktuelle Datenbank innerhalb der Schleife
         wird mithilfe der Methode select_db() der Klasse mysqli ausgewählt. */
      $con->select_db($dbname);

      /* Mithilfe der SQL-Anweisung SHOW TABLES werden:
         - eine Liste der Tabellen der aktuellen Datenbank und
         - die Anzahl dieser Tabellen
         ermittelt und gespeichert */
      $tabresult = $con->execute_query("SHOW TABLES FROM $dbname");
      $numtabs = $tabresult->num_rows;

      /* Die Ausgabe der Struktur der aktuellen Datenbank in Form einer HTML-Tabelle beginnt.
         Der Name der Datenbank und die Anzahl der Tabellen werden ausgegeben. */
      $d++;
      echo "<table><tr>"
        . "<td colspan='8' style='background-color:#c3c3c3;'>"
        . "<b>Datenbank $d: $dbname</b><br>"
        . "$numtabs Tabelle(n)</td></tr>";

      /* Die Liste der Tabellen wird in einer Schleife durchlaufen. */
      $t = 0;
      while($tabdsatz = $tabresult->fetch_array())
      {
         /* Der Inhalt des ersten Felds jedes Ergebnisdatensatzes ist der Name der aktuellen Tabelle.
            Dieser wird gespeichert. */
         $t++;
         $tabname = $tabdsatz[0];

         /* Mithilfe der SQL-Anweisung SHOW COLUMNS werden:
            - eine Liste der Felder der aktuellen Tabelle und
            - die Anzahl dieser Felder
            ermittelt und gespeichert */
         $fdresult = $con->execute_query("SHOW COLUMNS FROM $tabname");
         $numfds = $fdresult->num_rows;

         /* Mithilfe der SQL-Anweisung SELECT werden:
            - eine Liste der Datensätze der aktuellen Tabelle und
            - die Anzahl dieser Datensätze
            ermittelt und gespeichert */
         $dataresult = $con->execute_query("SELECT * FROM $tabname");
         $numdata = $dataresult->num_rows;
         $dataresult->close();

         /* Gibt es Datensätze innerhalb der Tabelle, soll eine Schaltfläche dargestellt werden,
            die zur Anzeige aller Datensätze betätigt werden kann.
            In diesem Fall wird das zweite Programm der Anwendung aufgerufen (db_browser_b.php).
            Bei dessen Aufruf werden der Name der Datenbank und der Name der Tabelle
            als versteckte Formularelemente an das ausführende Programm übermittelt. */
         if($numdata==0)
            $ft = "&nbsp;";
         else
            $ft = "<form action='db_browser_b.php' method='post'>"
              . "<input type='hidden' name='dbname' value='$dbname'>"
              . "<input type='hidden' name='tabname' value='$tabname'>"
              . "<input type='submit' value='ansehen'>"
              . "</form>";

         /* Die Ausgabe der Struktur der aktuellen Tabelle wird begonnen.
            In einer Kopfzeile werden ausgegeben:
            - die Nummer der Datenbank,
            - die Nummer und der Name der Tabelle,
            - die Anzahl der Felder,
            - die Anzahl der Datensätze,
            - eventuell die Anzeige-Schaltfläche für die Datensätze,
            - der Name der Felder und
            - weitere Feldeigenschaften. */
         echo "<tr style='background-color:#c3c3c3;'>"
           . "<td>Tabelle $d / $t : $tabname<br>"
           . "$numfds Felder, $numdata Datensätze</td>"
           . "<td>$ft</td>"
           . "<td>Name:</td>"
           . "<td>Typ:</td>"
           . "<td>Null:</td>"
           . "<td>Key:</td>"
           . "<td>Default:</td>"
           . "<td>Extra:</td>"
           . "</tr>";

         /* Die Liste der Felder wird in einer Schleife durchlaufen. */
         $f = 0;
         while($fddsatz = $fdresult->fetch_array())
         {
            /* Die Datensätze dieser Liste enthalten der Reihe nach:
               - den Feldnamen,
               - den Felddatentyp,
               - die Nulleigenschaft des Felds (das Feld darf leer bleiben oder nicht),
               - die Schlüsseleigenschaft des Felds (auf dem Feld liegt ein eindeutiger Schlüssel oder ein Primärschlüssel),
               - den Default-Wert des Felds und
               - weitere besondere Eigenschaften (zum Beispiel ON UPDATE CURRENT TIMESTAMP oder AUTO_INCREMENT). */
            $f++;
            $fdname    = $fddsatz[0];
            $fdtype    = mb_strtoupper($fddsatz[1]);
            $fdnull    = $fddsatz[2];
            $fdkey     = $fddsatz[3];
            $fddefault = $fddsatz[4];
            $fdextra   = mb_strtoupper($fddsatz[5]);

            if(!$fdkey)     $fdkey = "&nbsp;";
            if(!$fddefault) $fddefault = "&nbsp;";
            if(!$fdextra)   $fdextra = "&nbsp;";

            /* Die laufende Nummer des Felds und die gesammelten Feldeigenschaften werden ausgegeben. */
            echo "<tr>"
              . "<td colspan='2'>Feld $d / $t / $f :</td>"
              . "<td>$fdname</td>"
              . "<td>$fdtype</td>"
              . "<td>$fdnull</td>"
              . "<td>$fdkey</td>"
              . "<td>$fddefault</td>"
              . "<td>$fdextra</td>"
              . "</tr>";
         }
         $fdresult->close();
      }
      $tabresult->close();


      /* Nach Beendigung der beiden inneren Schleifen wird die HTML-Tabelle zur Ausgabe einer Datenbank beendet. */
      echo "</table><p>&nbsp;</p>";
   }
   $dbresult->close();
   
   $con->close();
?>
</body>
</html>
