<!DOCTYPE html>
<html lang="de">
<head>
   <meta charset="utf-8">
   <title>Datensätze</title>
   <style>
      table,td {border:1px solid black;}
   </style>
</head>
<body>
<?php
   /* Dieser Teil der Anwendung dient zur Darstellung der Inhalte der ausgewählten Tabelle.
      Er enthält keine neu hinzugekommenen SQL-Anweisungen oder Methoden.
      Beim Aufruf dieses Teils der Anwendung werden:
      - der Name der Datenbank und
      - der Name der Tabelle
      als versteckte Formularelemente an das Programm übergeben. */

   /* Die Verbindung wird aufgenommen und die Datenbank ausgewählt. */
   $con = new mysqli("localhost", "root", "", $_POST["dbname"]);

   /* Mithilfe der SQL-Anweisung SELECT werden:
      - eine Liste der Datensätze der aktuellen Tabelle und
      - die Anzahl dieser Datensätze
      ermittelt und gespeichert */
   $dataresult = $con->execute_query("SELECT * FROM " . $_POST["tabname"]);
   $numdata = $dataresult->num_rows;

   /* Die Ausgabe der Struktur der aktuellen Tabelle beginnt.
      Der Name der Datenbank und der Tabelle sowie die Anzahl der Datensätze werden ausgegeben. */
   echo "<h3>Datenbank " . $_POST["dbname"] . "</h3>";
   echo "<h4>Tabelle " . $_POST["tabname"] . "</h4>";
   echo "<p>$numdata Zeile(n):</p>";

   /* Die Liste und die Anzahl der Felder wird aus der Abfrage mit der SQL-Anweisung SHOW COLUMNS gewonnen.  */
   $fdresult = $con->execute_query("SHOW COLUMNS FROM " . $_POST["tabname"]);
   $numfds = $fdresult->num_rows;

   /* In de ersten Zeile der HTML-Tabelle werden alle Feldnamen ausgeben. */
   echo "<table><tr>";
   while($fddsatz = $fdresult->fetch_array())
      echo "<td style='background-color:#c3c3c3;'>$fddsatz[0]</td>";
   echo "</tr>";
   $fdresult->close();

   /* Die Liste der Datensätze wird in einer Schleife durchlaufen. */
   while($datadsatz = $dataresult->fetch_array())
   {
      /* Alle Felder werden in einer Schleife durchlaufen. */
      echo "<tr>";
      for($f=0; $f<$numfds; $f++)
      {
         /* Der Feldinhalt wird ermittelt und ausgeben.
            Leere Einträge werden in der HTML-Tabelle mit einem expliziten Leerzeichen abgebildet. */
         $data = $datadsatz[$f];
         if($data=="") $data = "&nbsp;";
         echo "<td>$data</td>";
      }
      echo "</tr>";
   }

   echo "</table>";
   
   $dataresult->close();
   $con->close();
?>
</body>
</html>
