<!DOCTYPE html>
<html lang="de">
<head>
   <meta charset="utf-8">
   <title>Eventplanung</title>
   <style>
      body,td {font-family:Verdana; font-size:10pt; color:#333333; background-color:#e3e3e3}
      td {padding-right:10px;}
   </style>
</head>
<body>
<h3>Eventplanung</h3>

<p>Ein einfach gestaltetes Programm zur Planung von Events.<br>
Tragt Euren Namen ein, wählt die Anzahl aus, die Ihr mitbringt, und sendet den Eintrag ab.<br>
Jedem Teilnehmer ist bewußt, dass die Daten unverschlüsselt übertragen werden,<br>
offen einsehbar sind und nach vier Wochen automatisch gelöscht werden.</p>

<script type="text/javascript">
function send(id)
{
   /* Im versteckten Formularfeld "id" wird die ID desjenigen Postens übergeben, bei dem sich der Helfer einträgt. */
   document.f.id.value = id;
   document.f.submit();
}
</script>

<?php
   $con = new mysqli("localhost", "root", "", "eventplanung");

   /* Falls ein Helfer etwas eingegeben und gesendet hat, werden diese Daten gespeichert. */
   if(isset($_POST["id"]))
   {
      $id = $_POST["id"];
      $name = $_POST["name"][$id];
      /* Der Helfer muss seinen Namen eintragen, damit seine Daten gespeichert werden. */
      if($name != "")
      {
         /* Für den betreffenden Posten wird die Liste der Namen der bisherigen Helfer
            und die Summe ihrer mitgebrachten Elemente ermittelt. */
         $sql = "SELECT * FROM event WHERE id = $id";
         $res = $con->execute_query($sql);
         $dsatz = $res->fetch_assoc();
         $beitraege_bisher = $dsatz["beitraege"];
         $mitgebracht_bisher = intval($dsatz["mitgebracht"]);
         $res->close();

         /* Die neue Summe der mitgebrachten Elemente wird ermittelt. */
         $mitgebracht_neu = intval($_POST["mitgebracht"][$id]);
         $mitgebracht = $mitgebracht_bisher + $mitgebracht_neu;

         /* Mit dem Namen des neuen Helfers wird die Liste der Namen der Helfer erstellt bzw. verlängert. */
         $beitraege_neu = $name . " (" . $mitgebracht_neu . ")";
         if($beitraege_bisher == "")
            $beitraege = $beitraege_neu;
         else
            $beitraege = $beitraege_bisher . ", " . $beitraege_neu;

         /* Die Daten des betreffenden Postens werden aktualisiert. */
         $sql = "UPDATE event SET beitraege = ?, mitgebracht = ? WHERE id = $id";
         $con->execute_query($sql, [$beitraege, $mitgebracht]);
      }

      /* Falls kein Name eingetragen wurde. */
      else
         echo "<p style='color:#ff0000;'>Name: Bitte eintragen</p>";
   }
?>  

<!-- Programm mit Formular ruft sich selbst auf. -->
<form name="f" action="db_eventplanung.php" method="post">

<!-- Im versteckten Formularfeld "id" wird die ID desjenigen Postens übergeben, bei dem sich der Helfer einträgt. -->
<input name="id" type="hidden">

<table>
<!-- Überschrift der Tabelle. -->
<tr>
  <td><b>Gewünscht</b></td>
  <td><b>Mitgebracht</b></td>
  <td><b>Name</b></td>
  <td><b>Anzahl</b></td>
  <td><b>Aktion</b></td>
</tr>

<?php
   $sql = "SELECT * FROM event";
   $res = $con->execute_query($sql);

   /* Ausgabe der Posten, inklusive der soeben erfolgten Änderungen. */
   while($dsatz = $res->fetch_assoc())
   {
      $id = $dsatz["id"];
      echo "<tr>";
      echo "<td>" . $dsatz["posten"] . " (" . $dsatz["gewuenscht"] . " " . $dsatz["einheit"] . ")</td>";
      echo "<td>" . $dsatz["beitraege"] . "</td>";

      /* Die Anzahl der noch benötigten Elemente des jeweiligen Postens wird ermittelt. */
      $fehlt = intval($dsatz["gewuenscht"]) - intval($dsatz["mitgebracht"]);

      /* Falls für diesen Posten noch Elemente benötigt werden. */
      if($fehlt > 0)
      {
         /* Für jeden Posten gibt es ein eigenes Feld für den Namen des neuen Helfers und
            eine eigene Liste, in der er die Anzahl der Elemente auswählen kann, die er mitbringt. */
         echo "<td><input name='name[$id]' size='15'></td>";
         echo "<td style='text-align:right;'><select name='mitgebracht[$id]'>";
         echo "<option value='1' selected='selected'>1</option>";
         /* Es kann maximal die Anzahl der noch benötigten Elemente ausgewählt werden. */
         for($i=2; $i<=$fehlt; $i++)
            echo "<option value='$i'>$i</option>";
         echo "</select></td>";
         echo "<td><a href='javascript:send($id);'>Senden</a></td>";
      }

      /* Falls für diesen Posten keine Elemente mehr benötigt werden. */
      else
      {
         echo "<td>&nbsp;</td>";
         echo "<td>&nbsp;</td>";
         echo "<td>Alles da</td>";
      }
    
      echo "</tr>";
   }
   $res->close();
   $con->close();
?>
</table>
</form>
</body>
</html>
