<!DOCTYPE html>
<html lang="de">
<head>
   <meta charset="utf-8">
   <title>Eventplanung, Eingabe</title>
   <!-- In jeder Tabellenzelle wird mit padding-right ein Abstand zum rechten Nachbarn gesetzt. -->
   <style>
      body,td {font-family:Verdana; font-size:10pt; color:#333333; background-color:#e3e3e3}
      td {padding-right:10px;}
   </style>
</head>
<body>
<?php
   include "pruefen.inc.php";
   $con = new mysqli("localhost", "root", "", "eventplanung");

   /* Falls der Organisator etwas gesendet hat, werden die Daten geprüft. */
   if(isset($_POST["gesendet"]))
   {
      /* Falls der Organisator keinen Posten oder keine Einheit eingegeben hat, erfolgt eine Fehlermeldung. */
      if($_POST["posten"] == "" || $_POST["einheit"] == "")
         echo "<p style='color:#ff0000;'>Bitte Posten und Einheit eintragen</p>";

      /* Falls die gewünschte Anzahl ganzzahlig und positiv ist, werden die Daten gespeichert. */
      else if(int_positiv("Gewünscht", $_POST["gewuenscht"], $gw))
      {
         $sql = "INSERT INTO event (posten, gewuenscht, einheit) VALUES (?, ?, ?)";
         $con->execute_query($sql, [$_POST["posten"], $gw, $_POST["einheit"]]);
      }
   }
?>
<h3>Eventplanung, Eingabe</h3>

<!-- Programm mit Formular ruft sich selbst auf. -->
<form action="db_eventplanung_eingabe.php" method="post">

<table>
<!-- Überschrift der Tabelle. -->
<tr>
   <td><b>Posten</b></td>
   <td><b>Gewünscht</b></td>
   <td><b>Einheit</b></td>
</tr>

<!-- Tabellenzeile für die Eingabe eines neuen Postens.
     Eingabefeld für die gewünschte Anzahl rechtsbündig in Tabellenzelle. -->
<tr>
   <td><input name="posten" size="25"></td>
   <td style="text-align:right;"><input name="gewuenscht" size="5"></td>
   <td><input name="einheit" size="10" value="Stück"></td>
   <td><input name="gesendet" type="submit" value="Senden"></td>
</tr>

<?php
   $sql = "SELECT * FROM event";
   $res = $con->execute_query($sql);

   /* Ausgabe der bisher gespeicherten Posten, inklusive desjenigen, der soeben gespeichert wurde.
      Gewünschte Anzahl rechtsbündig in Tabellenzelle. */
   while($dsatz = $res->fetch_assoc())
   {
      echo "<tr>";
      echo "<td>" . $dsatz["posten"] . "</td>";
      echo "<td style='text-align:right;'>" . $dsatz["gewuenscht"] . "</td>";
      echo "<td>" . $dsatz["einheit"] . "</td>";
      echo "</tr>";
   }
   $res->close();
   $con->close();
?>
</table>
</form>
</body>
</html>
