<!DOCTYPE html>
<html lang="de">
<head>
   <meta charset="utf-8">
   <title>Hinzufügen, Ändern, Löschen</title>
   <!-- Es wird eine CSS-Formatierungsdatei benötigt, Erläuterung siehe dort -->
   <link rel="stylesheet" type="text/css" href="db_linkcss.css">

<script type="text/javascript">
/* Die JavaScript-Funktion send() erwartet zwei Parameter und wird über einen der Hyperlinks im Dokument aufgerufen.
   Sie dient zum Absenden der Daten, zur Übermittlung der gewünschten Aktion sowie ggf. zur Identifizierung des betroffenen Datensatzes.
   Der Parameter "aktion" kann einen der folgenden Werte annehmen:
   - Wert 0: Ein neuer Datensatz soll eingetragen werden.
   - Wert 1: Ein Datensatz soll geändert werden.
   - Wert 2: Ein Datensatz soll gelöscht werden.
   - Wert 3 bis Wert 7: Die Datensätze sollen nach einem der fünf Felder sortiert werden. */
function send(aktion,id)
{
   /* Soll ein Datensatz gelöscht werden, wird als Rückfrage die vordefinierte JavaScript-Funktion confirm() aufgerufen.
      Wird diese Rückfrage mit OK bestätigt, liefert die Funktion confirm() den Wert "true" zurück.
      Wird dagegen die Schaltfläche "abbrechen" betätigt, wird der Wert "false" zurückgeliefert.
      In diesem Fall wird die Funktion send() abgebrochen, und das Formular wird nicht gesendet. */
   if(aktion==2)
      if(!confirm("Datensatz mit P-Nr " + id + " entfernen?"))
         return;

   /* Der Wert des Parameters "aktion" wird dem versteckten Formularfeld "aktion" zugewiesen. */
   document.f.aktion.value = aktion;

   /* Der Parameter "id" dient zur Identifikation des Datensatzes, falls dieser geändert oder gelöscht werden soll.
   Sein Wert wird dem versteckten Formularelement "id" zugewiesen. Anschließend wird das Formular gesendet. */
   document.f.id.value = id;
   document.f.submit();
}
</script>
</head>

<!-- Zur Erläuterung der Benutzeroberfläche der Anwendung:

     In der ersten Zeile finden sich die Feldnamen.
     In der zweiten Zeile stehen fünf leere Eingabefelder zum Eintragen der Daten eines neuen Datensatzes bereit.
     Nach dem Eintragen kann der Hyperlink "neu eintragen" betätigt werden.
     Dieser führt zu einer INSERT-Anweisung zum Erzeugen des neuen Datensatzes.
     Anschließend werden alle Datensätze neu angezeigt.

     In den darauffolgenden Zeilen stehen die Daten aller Datensätze in den Eingabefeldern zum Ändern bereit.
     Nach dem Ändern der Daten eines bestimmten Datensatzes kann der Hyperlink "speichern" betätigt werden.
     Dieser führt zu einer UPDATE-Anweisung zum Ändern des Datensatzes.
     Anschließend werden auch hier alle Datensätze neu angezeigt.

     Wird innerhalb einer Zeile der zugehörige Hyperlink "entfernen" betätigt,
     erscheint eine Rückfrage, ob der betreffende Datensatz tatsächlich gelöscht werden soll.
     Wird die Rückfrage mit OK bestätigt, führt dies zu einer DELETE-Anweisung
     zum Löschen des Datensatzes und zur erneuten Anzeige aller verbliebenen Datensätze.

     Bei allen Abfragen wird mit der Methode execute_query() gearbeitet, gegebenenfalls werden Prepared Statements verwendet. -->

<body>
<?php
/* Die beiden bekannten Dateien mit den Prüfungs- bzw. Formatierungsfunktionen werden eingebunden.
   Die Verbindung zum Datenbankserver wird aufgenommen und die Datenbank wird ausgewählt. */
   include "pruefen.inc.php";
   include "zeit.inc.php";
   $con = new mysqli("localhost", "root", "", "firma");

   /* Der Teil der SQL-Anweisung, der zur Sortierung dient, wird standardmäßig vorbesetzt.
      Dieser Teil kann sich gegebenenfalls noch ändern. */
   $od = " ORDER BY personalnummer";

   /* Es wird untersucht, ob das Feldelement $_POST["aktion"] existiert:
      - Beim ersten Aufruf des Dokuments ist das noch nicht der Fall. Daher wird der folgende Block übergangen.
      - Ruft sich das Dokument selbst auf, weil eine der Aktionen ausgelöst wird,
        existiert das Feldelement $_POST["aktion"] und sein Wert wird untersucht. */
   if(isset($_POST["aktion"]))
   {
      /* Soll ein neuer Datensatz eingetragen werden, wird nach den Prüfungen die SQL-Anweisung INSERT zusammengesetzt.
         Dabei werden die Werte der Formularelemente aus der zweiten Zeile (direkt unter der Überschrift) genommen.
         Diese haben die Namen na[0], vn[0] usw. 
         Sie werden als Elemente eines zweidimensionalen Felds an das PHP-Programm übermittelt und
         haben dort die Namen $_POST["na"][0] und $_POST["vn"][0]. */
      if($_POST["aktion"] == "0")
      {
         $fehler = false;

         if(int_positiv("Personalnummer", $_POST["pn"][0], $pn))
         {
            if(pk_neu_doppelt("Personalnummer", $pn,
                  $con, "personen", "personalnummer"))
               $fehler = true;
         }
         else      
            $fehler = true;
      
         if(!float_positiv("Gehalt", $_POST["ge"][0], $ge))
            $fehler = true;

         if(!datum_gueltig("Geburtsdatum", $_POST["gt"][0], $gt))
            $fehler = true;

         if(!$fehler)
         {
            $sql = "INSERT INTO personen(name, vorname,"
               . " personalnummer, gehalt, geburtstag) VALUES(?, ?, ?, ?, ?)";
            $na = $_POST["na"][0];
            $vn = $_POST["vn"][0];
            $con->execute_query($sql, [$na, $vn, $pn, $ge, $gt]);
         }
      }

      /* Soll ein Datensatz geändert werden, wird nach den Prüfungen die SQL-Anweisung UPDATE benutzt.
         Dabei werden die Werte der Formularelemente aus der betreffenden Zeile genommen.
         Bei einem Datensatz, dessen Personalnummer zum Beispiel 4711 ist, haben diese Formularelemente die Namen na[4711], vo[4711] usw.
         Sie sind für PHP ebenso Elemente des zweidimensionalen Felds und haben dort die Namen $_POST["na"][4711] und $_POST["vn"][4711].
         Der Datensatz wird über den Wert (hier: 4711) des Feldelements $_POST["id"] identifiziert,
         der in dem versteckten Formularelement übermittelt wird. */
      else if($_POST["aktion"] == "1")
      {
         $fehler = false;
         $id = $_POST["id"];

         if(int_positiv("Personalnummer", $_POST["pn"][$id], $pn))
         {
            if(pk_aendern_doppelt("Personalnummer", $pn, $id,
                  $con, "personen", "personalnummer"))
            $fehler = true;
         }
         else      
            $fehler = true;
      
         if(!float_positiv("Gehalt", $_POST["ge"][$id], $ge))
            $fehler = true;

         if(!datum_gueltig("Geburtsdatum", $_POST["gt"][$id], $gt))
            $fehler = true;

         if(!$fehler)
         {
            $sql = "UPDATE personen SET name = ?, vorname = ?,"
               . " personalnummer = ?, gehalt = ?, geburtstag = ?"
               . " WHERE personalnummer = $id";
            $na = $_POST["na"][$id];
            $vn = $_POST["vn"][$id]; 
            $con->execute_query($sql, [$na, $vn, $pn, $ge, $gt]);
         }
      }

      /* Soll ein Datensatz gelöscht werden (Wert 2), wird die SQL-Anweisung DELETE verwendet.
         Der Datensatz wird ebenso über den Wert des Feldelements $_POST["id"] identifiziert. */
      else if($_POST["aktion"] == "2")
      {
         $id = $_POST["id"];
         $sql = "DELETE FROM personen WHERE personalnummer = $id";
         $con->execute_query($sql);
      }

      /* Sollen die Datensätze sortiert werden (Werte 3 bis 7),
         wird derjenige Teil der SQL-Anweisung überschrieben, der zur Sortierung dient.
         Diese mehrfache Verzweigung mit insgesamt sieben möglichen Fällen könnte auch mithilfe eines switch-Blocks realisiert werden.
         Allerdings sieht man bei der vorliegenden Lösung mit if-else besser, welche Variable immer wieder geprüft wird. */
      else if($_POST["aktion"] == "3") $od = " ORDER BY name";
      else if($_POST["aktion"] == "4") $od = " ORDER BY vorname";
      else if($_POST["aktion"] == "5") $od = " ORDER BY personalnummer";
      else if($_POST["aktion"] == "6") $od = " ORDER BY gehalt";
      else if($_POST["aktion"] == "7") $od = " ORDER BY geburtstag";
   }

   /* Das Programm ruft sich selbst auf.
      Das Formular enthält die beiden versteckten Formularelemente aktion und id,
      die ihre Werte von der oben beschriebenen JavaScript-Funktion send() erhalten. */
   echo "<form name='f' action='db_linkcss.php' method='post'>"
      . "<input name='aktion' type='hidden'>"
      . "<input name='id' type='hidden'>\n\n";

   /* Es folgt die Tabellenüberschrift inklusive der Hyperlinks zum Sortieren.
      Die Hyperlinks lösen jeweils den Aufruf der JavaScript-Funktion send() aus.
      Der erste Parameter hat einen der Werte von 3 bis 7.
      Damit wird der Wert des versteckten Formularelements aktion auf den entsprechenden Wert gesetzt.
      Der zweite Parameter ist für diesen Aufruf nicht wichtig, muss aber besetzt werden, da die Funktion zwei Parameter erwartet. */
   echo "<table><tr>"
      . "<td><a href='javascript:send(3,0);'>Name</a></td>"
      . "<td><a href='javascript:send(4,0);'>Vorname</a></td>"
      . "<td><a href='javascript:send(5,0);'>P-Nr</a></td>"
      . "<td><a href='javascript:send(6,0);'>Gehalt</a></td>"
      . "<td><a href='javascript:send(7,0);'>Geburtstag</a></td>"
      . "<td>Aktion</td></tr>\n\n";

   /* Nach dem schließenden </tr> sehen Sie im Code das Sonderzeichen \n. Es führt zu einem Zeilenumbruch im HTML-Code.
      Zwei \n hintereinander erzeugen somit einen Zeilenumbruch und eine Leerzeile.
      Dies kann Ihnen zur besseren Orientierung dienen, falls Sie den von PHP generierten
      HTML-Code im Quelltext der Seite kontrollieren möchten, um einen möglichen Fehler zu finden.
      Bei vielen Browsern gelangen Sie über den Kontextmenüeintrag "Seitenquelltext anzeigen" zu dieser Anzeige. */

   /* Die Zeile mit den Eingabefeldern für einen neuen Datensatz wird zusammengesetzt.
      Die Felder erhalten die Namen na[0], vn[0] usw. Die Feldinhalte werden für die SQL-Anweisung INSERT benötigt.
      Der Hyperlink "neu eintragen" ruft ebenfalls die JavaScript-Funktion send() auf, mit dem Wert 0.
      Auch hier ist der zweite Parameter nicht wichtig. */
   echo "<tr>"
      . "<td><input name='na[0]' size='6'></td>"
      . "<td><input name='vn[0]' size='6'></td>"
      . "<td><input name='pn[0]' size='6'></td>"
      . "<td><input name='ge[0]' size='6'></td>"
      . "<td><input name='gt[0]' size='10'></td>"
      . "<td><a href='javascript:send(0,0);'>neu eintragen</a></td>"
      . "</tr>\n\n";

   /* Nach Ausführung der Aktion sollen alle vorhandenen Datensätze angezeigt werden.
      Dies betrifft auch die neuen beziehungsweise geänderten, nicht aber die gelöschten Datensätze.
      Hierzu dient die SQL-Anweisung SELECT. */
   $sql = "SELECT * FROM personen $od";
   $res = $con->execute_query($sql);

   /* Innerhalb der Schleife wird jeweils ein Datensatz ausgegeben. */
   while($dsatz = $res->fetch_assoc())
   {
      /* Die Variable $id erhält den Wert der Personalnummer des aktuellen Datensatzes.
         Diese Variable wird zur Indizierung der verschiedenen Felder von Formularelementen und
         für den Aufruf der JavaScript-Funktion send() benötigt. */
      $id = $dsatz["personalnummer"];

      /* Die aktuellen Werte jedes Datensatzes werden zunächst jeweils in einer eigenen Variablen gespeichert.
         Diese Variablen lassen sich besser in die PHP-Anweisung einbetten statt der Elemente des Feldes $dsatz. */
      $na = $dsatz["name"];
      $vn = $dsatz["vorname"];
      $pn = $dsatz["personalnummer"];
      $ge = $dsatz["gehalt"];
      $gt = db_datum_aus($dsatz["geburtstag"]);

      /* Bei einem Datensatz, dessen Personalnummer 4711 ist, werden die zugehörigen input-Elemente na[4711], vn[4711] usw. genannt.
         Für PHP werden sie damit zu Elementen eines numerisch indizierten Felds. */
      echo "<tr>"
         . "<td><input name='na[$id]' value='$na' size='6'></td>"
         . "<td><input name='vn[$id]' value='$vn' size='6'></td>"
         . "<td><input name='pn[$id]' value='$pn' size='6'></td>"
         . "<td><input name='ge[$id]' value='$ge' size='6'></td>"
         . "<td><input name='gt[$id]' value='$gt' size='10'></td>";

      /* Auf jeden Datensatz folgen zwei Hyperlinks. Beide rufen die JavaScript-Funktion send() auf.
         Der erste Parameter hat den Wert 1 (zum Ändern) beziehungsweise 2 (zum Löschen).
         Der zweite Parameter hat den Wert der Personalnummer, im obigen Beispiel 4711.
         Alle Hyperlinks "speichern" beziehungsweise "entfernen" sind also individuell.

         Sie können die Ziele der Hyperlinks kontrollieren, indem Sie die Maus darüber schweben lassen.
         Bei vielen Browsern werden die Ziele dann in der Statuszeile angezeigt. */
      echo "<td><a href='javascript:send(1,$id);'>speichern</a>"
         . " <a href='javascript:send(2,$id);'>entfernen</a></td>"
         . "</tr>\n\n";
   }
   echo "</table></form>";
   $res->close();
   $con->close();
?>
</body></html>
