<!DOCTYPE html>
<html lang="de">
<head>
   <meta charset="utf-8">
   <title>Abfragen</title>
   <link rel="stylesheet" type="text/css" href="db_linkcss.css">
</head>
<body>
<?php
   /* Es werden drei Abfragen formuliert und es wird mit Gruppierungsfunktionen gearbeitet.
      Zwei der drei Abfragen erstrecken sich über mehrere Tabellen. */
   $con = new mysqli("localhost", "root", "", "projektverwaltung");

   /* Die Anzahl der Kunden wird mithilfe der Aggregatfunktion COUNT() ermittelt.
      Das Ergebnisfeld erhält den frei gewählten Aliasnamen "count_ku_id". */
   echo "<p><b>Anzahl der Kunden:</b><br>";
   $sql = "SELECT COUNT(ku_id) as count_ku_id FROM kunde";
   $res = $con->execute_query($sql);
   while ($dsatz = $res->fetch_assoc())
      echo $dsatz["count_ku_id"] . "<br>";
   echo "</p>";
   $res->close();

   /* Die Summe der Arbeitszeiten jeder Person wird festgestellt. Für jeden Datensatz der Tabelle "person",
      dem mindestens ein Datensatz der Tabelle "arbeit" zugeordnet ist, wird ein Ergebnisdatensatz ausgegeben.
      Mithilfe der Aggregatfunktion SUM() werden alle Einträge im Feld "ar_zeit" aufsummiert, die zur selben Gruppe gehören.
      Die Gruppierung wird mithilfe von GROUP BY nach dem Feld "pe_id" der Tabelle "person" durchgeführt.
      Das Ergebnisfeld, das die berechnete Summe enthält, bekommt den Aliasnamen "sum_ar_zeit".
      Die Ausgabe ist nach Nachnamen sortiert. */
   echo "<p><b>Alle Personen mit Zeitsumme:</b><br>";
   $sql = "SELECT pe_nachname, SUM(ar_zeit) AS sum_ar_zeit"
      . " FROM person INNER JOIN arbeit ON person.pe_id = arbeit.ar_pe_id"
      . " GROUP BY person.pe_id"
      . " ORDER BY pe_nachname";
   $res = $con->execute_query($sql);
   while ($dsatz = $res->fetch_assoc())
      echo $dsatz["pe_nachname"] . ", " . $dsatz["sum_ar_zeit"] . "<br>";
   echo "</p>";
   $res->close();

   /* Die Summe der Arbeitszeiten für jedes Projekt wird ermittelt, ähnlich wie in der vorherigen Abfrage.
      Für jeden Datensatz der Tabelle "projekt", dem mindestens ein Datensatz der Tabelle "arbeit" zugeordnet ist,
      wird ein Ergebnisdatensatz ausgegeben.
      Die Gruppierung wird diesmal nach dem Feld "pr_id" der Tabelle "projekt" durchgeführt.
      Die Ausgabe ist nach Projektbezeichnung sortiert. */
   echo "<p><b>Alle Projekte mit Zeitsumme:</b><br>";
   $sql = "SELECT pr_bezeichnung, SUM(ar_zeit) AS sum_ar_zeit"
      . " FROM projekt INNER JOIN arbeit ON projekt.pr_id = arbeit.ar_pr_id"
      . " GROUP BY projekt.pr_id"
      . " ORDER BY pr_bezeichnung";
   $res = $con->execute_query($sql);
   while ($dsatz = $res->fetch_assoc())
      echo $dsatz["pr_bezeichnung"] . ", " . $dsatz["sum_ar_zeit"] . "<br>";
   echo "</p>";
   $res->close();

   $con->close();
?>
</body></html>
