<!DOCTYPE html>
<html lang="de">
<head>
   <meta charset="utf-8">
   <title>Projektverwaltung, Arbeitszeiten</title>
   <link rel="stylesheet" type="text/css" href="db_linkcss.css">

<!-- Das Programm zur Verwaltung der Arbeitszeiten hat einen ähnlichen Aufbau wie das Programm zur Verwaltung der Projekte.
     In den Kommentaren in dieser Datei werden nur die Unterschiede erläutert. -->

<script type="text/javascript">
function send(aktion,id)
{
   if(aktion==2)
      if(!confirm("Datensatz mit ID " + id + " entfernen?"))
         return;

   document.f.aktion.value = aktion;
   document.f.id.value = id;
   document.f.submit();
}
</script>

<?php
/* Die Funktion arbeitbereitsvorhanden() wird beim Neueintragen bzw. Ändern von Datensätzen genutzt.
   Falls es bereits eine Arbeitszeit für das aktuell ausgewählte Projekt, die aktuell ausgewählte Person und
   das aktuell eingegebene Datum gibt, findet die betreffende Aktion nicht statt.
   Es gibt allerdings einen Ausnahmefall:
   Wird bei ein und demselben Datensatz nur die Zeitangabe geändert, darf der Vorgang ausgeführt werden. */
function arbeitbereitsvorhanden($con, $aktion, $id, $pr, $pe, $da)
{
   $sql = "SELECT ar_id, ar_pr_id, ar_pe_id, ar_datum FROM arbeit"
      . " WHERE ar_pr_id = $pr AND ar_pe_id = $pe AND ar_datum = '$da'";
   $res = $con->execute_query($sql);
   $anzahl = $res->num_rows;
   if($anzahl > 0)
      $dsatz = $res->fetch_assoc();
   $res->close();
   if($anzahl > 0)
   {
      if($aktion == "aendern" && $id == $dsatz["ar_id"])
         return false;
      else
      {
         echo "<p style='color:#ff0000;'>Arbeitszeit bereits vorhanden</p>";
         return true;
      }
   }
   else
      return false;
}
?>
</head>

<body>
<p><a href="db_projektverwaltung.php">Zurück zum Hauptmenü</a></p>
<p>Arbeitszeiten:</p>
<?php
   include "pruefen.inc.php";
   include "zeit.inc.php";
   $con = new mysqli("localhost", "root", "", "projektverwaltung");

   /* In der Tabelle "arbeit" gibt es die Felder "ar_id", "ar_pr_id", "ar_pe_id", "ar_datum" und "ar_zeit".
      Das Feld "ar_pr_id" dient zur Verknüpfung mit der Tabelle der Projekte, das Feld "ar_pe_id" zur Verknüpfung mit der Tabelle der Personen.
      In der Darstellung kann sortiert werden nach:
      - ID
      - Projektbezeichnung mit Datum
      - Personenname mit Datum
      - Datum mit Projektbezeichnung und Personenname */
   $od = "ORDER BY ar_id";

   /* Aktion ausführen */
   if(isset($_POST["aktion"]))
   {
      /* Neu eintragen */
      if($_POST["aktion"] == "0")
      {
         $pr = $_POST["pr"][0];
         $pe = $_POST["pe"][0];
         $fehler = false;
         
         if(!datum_gueltig("Datum", $_POST["da"][0], $da))
            $fehler = true;
            
         if(!float_positiv("Zeit", $_POST["ze"][0], $ze))
            $fehler = true;
            
         if(!$fehler)
         {
            if(arbeitbereitsvorhanden($con, "neu", 0, $pr, $pe, $da, $ze))
               $fehler = true;
         }

         if(!$fehler)
         {
            $sql = "INSERT INTO arbeit(ar_pr_id, ar_pe_id,"
               . " ar_datum, ar_zeit) VALUES(?, ?, ?, ?)";
            $con->execute_query($sql, [$pr, $pe, $da, $ze]);
         }
      }

      /* Ändern */
      else if($_POST["aktion"] == "1")
      {
         $id = $_POST["id"];

         $pr = $_POST["pr"][$id];
         $pe = $_POST["pe"][$id];
         $fehler = false;
         
         if(!datum_gueltig("Datum", $_POST["da"][$id], $da))
            $fehler = true;
            
         if(!float_positiv("Zeit", $_POST["ze"][$id], $ze))
            $fehler = true;
            
         if(!$fehler)
         {
            if(arbeitbereitsvorhanden($con, "aendern", $id, $pr, $pe, $da, $ze))
               $fehler = true;
         }

         if(!$fehler)
         {
            $sql = "UPDATE arbeit SET ar_pr_id=?, ar_pe_id=?,"
               . " ar_datum=?, ar_zeit=? WHERE ar_id=$id";
            $con->execute_query($sql, [$pr, $pe, $da, $ze]);
         }
      }

      /* Löschen */
      else if($_POST["aktion"] == "2")
      {
         $id = $_POST["id"];
         $sql = "DELETE FROM arbeit WHERE ar_id=$id";
         $con->execute_query($sql);
      }

      /* Sortieren */
      else if($_POST["aktion"] == "3") $od = " ORDER BY ar_id";
      else if($_POST["aktion"] == "4") $od =
         " ORDER BY pr_bezeichnung, pe_nachname, pe_vorname, ar_datum";
      else if($_POST["aktion"] == "5") $od =
         " ORDER BY pe_nachname, pe_vorname, ar_datum";
      else if($_POST["aktion"] == "6") $od =
         " ORDER BY ar_datum, pr_bezeichnung, pe_nachname, pe_vorname";
   }

   /* Formularbeginn */
   echo "<form name='f' action='db_projektverwaltung_arbeit.php' method='post'>"
      . "<input name='aktion' type='hidden'>"
      . "<input name='id' type='hidden'>\n\n";

   /* Tabellenbeginn */
   echo "<table>"
      . "<tr>"
      . "<td><a href='javascript:send(3,0);'>ID</a></td>"
      . "<td><a href='javascript:send(4,0);'>Projekt</a></td>"
      . "<td><a href='javascript:send(5,0);'>Person</a></td>"
      . "<td><a href='javascript:send(6,0);'>Datum</a></td>"
      . "<td>Zeit</td>"
      . "<td>Aktion</td></tr>\n\n";

   /* In den beiden parallel aufgebauten Hilfsfeldern $pr_id_feld und $pr_feld stehen
      die zusammengehörigen Daten der miteinander verknüpften Tabellen "kunde" und "projekt". */
   $sql = "SELECT pr_id, pr_bezeichnung, ku_name, ku_ort"
      . " FROM kunde INNER JOIN projekt ON kunde.ku_id = projekt.pr_ku_id"
      . " ORDER BY pr_id";
   $res = $con->execute_query($sql);
   $pr_id_feld = array();
   $pr_feld = array();
   while($dsatz = $res->fetch_assoc())
   {
      array_push($pr_id_feld, $dsatz["pr_id"]);
      array_push($pr_feld, $dsatz["pr_bezeichnung"] . ", "
         . $dsatz["ku_name"] . " (" . $dsatz["ku_ort"] . ")");
   }
   $res->close();

   /* In den beiden parallel aufgebauten Hilfsfeldern $pe_id_feld und $pe_feld stehen die Daten der Tabelle "person". */
   $sql = "SELECT * FROM person";
   $res = $con->execute_query($sql);
   $pe_id_feld = array();
   $pe_feld = array();
   while($dsatz = $res->fetch_assoc())
   {
      array_push($pe_id_feld, $dsatz["pe_id"]);
      array_push($pe_feld, $dsatz["pe_nachname"] . ", " . $dsatz["pe_vorname"]);
   }
   $res->close();

   /* Neuer Eintrag */
   echo "<tr>"
      . "<td>&nbsp;</td>"
      . "<td><select name='pr[0]'>";
   /* Die vier Hilfsfelder werden für die Inhalte der beiden Auswahlmenüs verwendet. */
   for ($i=0; $i<count($pr_id_feld); $i++)
      echo "<option value='$pr_id_feld[$i]'>$pr_feld[$i]</option>";
   echo "</select></td>"
      . "<td><select name='pe[0]'>";
   for ($i=0; $i<count($pe_id_feld); $i++)
      echo "<option value='$pe_id_feld[$i]'>$pe_feld[$i]</option>";
   echo "</select></td>"
      . "<td><input name='da[0]' size='10'></td>"
      . "<td><input name='ze[0]' size='6'></td>"
      . "<td><a href='javascript:send(0,0);'>neu eintragen</a></td>"
      . "</tr>\n\n";

   /* Die zusammengehörigen Daten der drei Tabellen "projekt", "person" und "arbeit" werden miteinander verknüpft.
      Mithilfe des INNER JOIN innerhalb der Klammern wird dafür gesorgt, dass diejenigen Daten der beiden Tabellen
      "person" und "arbeit" miteinander verknüpft werden, bei denen die Inhalte der beiden Felder "pe_id" und "ar_pe_id" übereinstimmen.
      Mithilfe des INNER JOIN außerhalb der Klammern wird anschließend dafür gesorgt, dass diejenigen Daten der Tabelle
      "projekt" mit den zuvor bereits miteinander verknüpften Daten aus den beiden Tabellen "person" und "arbeit" verbunden werden,
      bei denen die Inhalte der beiden Felder "pr_id" und "ar_pr_id" übereinstimmen. */
   $sql = "SELECT ar_id, ar_pr_id, ar_pe_id, ar_datum, ar_zeit,"
      . " pr_id, pr_ku_id, pr_bezeichnung, pe_id, pe_nachname, pe_vorname"
      . " FROM projekt INNER JOIN(person INNER JOIN arbeit ON person.pe_id ="
      . " arbeit.ar_pe_id) ON projekt.pr_id = arbeit.ar_pr_id $od";
   $res = $con->execute_query($sql);

   /* Alle vorhandenen Datensätze */
   while($dsatz = $res->fetch_assoc())
   {
      $id = $dsatz["ar_id"];
      $pr = $dsatz["ar_pr_id"];
      $pe = $dsatz["ar_pe_id"];
      $da = db_datum_aus($dsatz["ar_datum"]);
      $ze = $dsatz["ar_zeit"];
      echo "<tr>"
         . "<td>$id</td>"
         . "<td><select name='pr[$id]'>";
      /* Im Auswahlmenü wird jeweils diejenige Option mithilfe des HTML-Attributs "selected" ausgewählt,
         bei der die ID des Projekts mit dem Element des Feldes $pr_id_feld übereinstimmt. */
      for ($i=0; $i<count($pr_id_feld); $i++)
      {
         echo "<option value='$pr_id_feld[$i]'";
         if($pr == $pr_id_feld[$i])
            echo " selected='selected'";
         echo ">$pr_feld[$i]</option>";
      }
      echo "</select></td>"
         . "<td><select name='pe[$id]'>";
      /* Im Auswahlmenü wird jeweils diejenige Option ausgewählt,
         bei der die ID der Person mit dem Element des Feldes $pe_id_feld übereinstimmt. */
      for ($i=0; $i<count($pe_id_feld); $i++)
      {
         echo "<option value='$pe_id_feld[$i]'";
         if($pe == $pe_id_feld[$i])
            echo " selected='selected'";
         echo ">$pe_feld[$i]</option>";
      }
      echo "</select></td>"
         . "<td><input name='da[$id]' value='$da' size='10'></td>"
         . "<td><input name='ze[$id]' value='$ze' size='6'></td>"
         . "<td><a href='javascript:send(1,$id);'>speichern</a>"
         . " <a href='javascript:send(2,$id);'>entfernen</a></td>"
         . "</tr>\n\n";
   }
   echo "</table></form>";
   $res->close();
   $con->close();
?>
</body></html>
