<!DOCTYPE html>
<html lang="de">
<head>
   <meta charset="utf-8">
   <title>Projektverwaltung, Kunden</title>
   <link rel="stylesheet" type="text/css" href="db_linkcss.css">

<script type="text/javascript">
/* Beim Betätigen der Links "neu eintragen", "speichern" oder "entfernen"
   werden die Werte 0, 1 oder 2 an den ersten Parameter der Funktion send() übergeben.
   Wird einer der beiden letztgenannten Links betätigt, wird zusätzlich die ID des zugehörigen Datensatzes an den zweiten Parameter übergeben.
   Enthält der erste Parameter den Wert 2, erfolgt eine Rückfrage, ob der Datensatz wirklich entfernt werden soll.
   Beide Parameter werden an die versteckten Formularelemente aktion und id übergeben und das Formular wird gesendet. */
function send(aktion,id)
{
   if(aktion==2)
      if(!confirm("Datensatz mit ID " + id + " entfernen?"))
         return;

   document.f.aktion.value = aktion;
   document.f.id.value = id;
   document.f.submit();
}
</script>

<?php
/* Die Funktion kundebereitsvorhanden() wird beim Neueintragen oder Ändern eines Datensatzes benötigt.
   Mithilfe eines Prepared Statements wird geprüft, ob es bereits einen Datensatz mit den aktuell eingegebenen Daten für Name und Ort gibt.
   Ist das der Fall, liefert die Funktion "true" zurück und das Neueintragen bzw. Ändern des Datensatzes wird nicht ausgeführt. */
function kundebereitsvorhanden($con, $na, $or)
{
   $sql = "SELECT * FROM kunde WHERE ku_name = ? AND ku_ort = ?";
   $res = $con->execute_query($sql, [$na, $or]);
   $anzahl = $res->num_rows;
   $res->close();
   if($anzahl > 0)
      return true;
   else
      return false;
}
?>
</head>

<body>
<!-- Ein Link zum Hauptmenü. -->
<p><a href="db_projektverwaltung.php">Zurück zum Hauptmenü</a></p>
<p>Kunden:</p>
<?php
   $con = new mysqli("localhost", "root", "", "projektverwaltung");

   /* Standardmäßig wird die Sortierung der Datensätze nach der Kunden-ID vorgenommen.
      Dieser Teil der SQL-Anweisung wird in der Variablen $od gespeichert.
      Wird später eine andere Sortierung gewünscht, wird die Variable $od überschrieben. */
   $od = "ORDER BY ku_id";

   /* Falls eine der Aktionen "neu eintragen", "speichern" oder "entfernen" ausgeführt wird. */
   if(isset($_POST["aktion"]))
   {
      /* Falls ein neuer Datensatz eingetragen werden soll:
         Es wird geprüft, ob eines der beiden Eingabefelder leer ist.
         Ist das der Fall, erfolgt eine Fehlermeldung.
         Ist das nicht der Fall, wird die Funktion kundebereitsvorhanden() aufgerufen.
         Liefert sie die Information, dass es noch keinen Kunden mit den eingegebenen Daten für Name und Ort gibt,
         wird der Datensatz mithilfe eines Prepared Statements zur Datenbank hinzugefügt. */
      if($_POST["aktion"] == "0")
      {
         if($_POST["na"][0] == "" || $_POST["or"][0] == "")
            echo "<p style='color:#ff0000;'>Bitte Name und Ort eintragen</p>";
         else if(kundebereitsvorhanden($con, $_POST["na"][0], $_POST["or"][0]))
            echo "<p style='color:#ff0000;'>Kunde bereits vorhanden</p>";
         else
         {
            $sql = "INSERT INTO kunde(ku_name, ku_ort) VALUES(?, ?)";
            $con->execute_query($sql, [$_POST["na"][0], $_POST["or"][0]]);
         }
      }

      /* Falls ein Datensatz geändert werden soll:
         Ist keines der beiden Eingabefelder leer und gibt es keinen anderen Datensatz mit den geänderten Daten für Name und Ort,
         wird der Datensatz mithilfe eines Prepared Statements und diesen Daten aktualisiert. */
      else if($_POST["aktion"] == "1")
      {
         $id = $_POST["id"];
         if($_POST["na"][$id] == "" || $_POST["or"][$id] == "")
            echo "<p style='color:#ff0000;'>Bitte Name und Ort eintragen</p>";
         else if(kundebereitsvorhanden(
               $con, $_POST["na"][$id], $_POST["or"][$id]))
            echo "<p style='color:#ff0000;'>Kunde bereits vorhanden</p>";
         else
         {
            $sql = "UPDATE kunde SET ku_name=?, ku_ort=? WHERE ku_id=$id";
            $con->execute_query($sql, [$_POST["na"][$id], $_POST["or"][$id]]);
         }
      }

      /* Falls ein Datensatz gelöscht werden soll:
         Mithilfe der ersten SQL-Anweisung wird geprüft, ob es Datensätze in der Tabelle der Projekte gibt, die dem zu löschenden Kunden zugeordnet sind.
         Ist das der Fall, darf der Kunde nicht gelöscht werden, da ansonsten die Verbindung zwischen den Tabellen "kunde" und "projekt" verloren gehen würde.
         In der Tabelle der Projekte gäbe es dann verwaiste Datensätze.
         Gibt es keine zugehörigen Datensätze in der Tabelle der Projekte, wird der Datensatz für den Kunden mithilfe eines Prepared Statements gelöscht. */
      else if($_POST["aktion"] == "2")
      {
         $id = $_POST["id"];
         $sql = "SELECT * FROM projekt WHERE pr_ku_id = $id";
         $res = $con->execute_query($sql);
         $anzahl = $res->num_rows;
         $res->close();

         if($anzahl > 0)
            echo "<p style='color:#ff0000;'>Kunde hat Projekte</p>";
         else
         {
            $sql = "DELETE FROM kunde WHERE ku_id = $id";
            $con->execute_query($sql);
         }
      }

      /* In Abhängigkeit des übermittelten Werts für das versteckte Formularelement "aktion" werden der Variablen $od unterschiedliche Werte zugewiesen.
         Damit wird die SQL-Anweisung zur Auswahl und Sortierung der dargestellten Datensätze vervollständigt. */
      else if($_POST["aktion"] == "3") $od = " ORDER BY ku_id";
      else if($_POST["aktion"] == "4") $od = " ORDER BY ku_name";
      else if($_POST["aktion"] == "5") $od = " ORDER BY ku_ort";
   }

   /* Das Formular ruft sich selbst auf. */
   echo "<form name='f' action='db_projektverwaltung_kunde.php' method='post'>"
      . "<input name='aktion' type='hidden'>"
      . "<input name='id' type='hidden'>\n\n";

   /* Die Überschriften der Tabellenspalten entsprechen Links zum Sortieren.
      Je nach Spalte werden dabei die Werte 3, 4 bzw. 5 an den ersten Parameter der JavaScript-Funktion send() übergeben. */
   echo "<table>"
      . "<tr>"
      . "<td><a href='javascript:send(3,0);'>ID</a></td>"
      . "<td><a href='javascript:send(4,0);'>Name</a></td>"
      . "<td><a href='javascript:send(5,0);'>Ort</a></td>"
      . "<td>Aktion</td></tr>\n\n";

   /* Es folgen die Felder zur Eingabe der Werte eines neuen Kunden.
      Beim Betätigen des Links "neu eintragen" wird der Wert 0 an den ersten Parameter der JavaScript-Funktion send() übergeben. */
   echo "<tr>"
      . "<td>&nbsp;</td>"
      . "<td><input name='na[0]' size='10'></td>"
      . "<td><input name='or[0]' size='10'></td>"
      . "<td><a href='javascript:send(0,0);'>neu eintragen</a></td>"
      . "</tr>\n\n";

   /* Alle Daten aller Kunden werden zur Ausgabe ausgewählt.
      Die Variable $od enthält denjenigen Teil der SQL-Anweisung, der zum Sortieren benötigt wird. */
   $sql = "SELECT * FROM kunde $od";
   $res = $con->execute_query($sql);

   /* Es werden alle Datensätze ausgegeben.
      Der Inhalt des Felds "ku_id" ist nicht änderbar.
      Die Inhalte der Felder "ku_name" und "ku_ort" erscheinen in den Eingabefeldern.
      Beim Betätigen der Links "speichern" und "entfernen" werden die Werte 1 oder 2 an die JavaScript-Funktion send() übergeben. */
    while($dsatz = $res->fetch_assoc())
   {
      $id = $dsatz["ku_id"];
      $na = $dsatz["ku_name"];
      $or = $dsatz["ku_ort"];
      echo "<tr>"
         . "<td>$id</td>"
         . "<td><input name='na[$id]' value='$na' size='10'></td>"
         . "<td><input name='or[$id]' value='$or' size='10'></td>"
         . "<td><a href='javascript:send(1,$id);'>speichern</a>"
         . " <a href='javascript:send(2,$id);'>entfernen</a></td>"
         . "</tr>\n\n";
   }
   echo "</table></form>";
   $res->close();
   $con->close();
?>
</body></html>
