<!DOCTYPE html>
<html lang="de">
<head>
   <meta charset="utf-8">
   <title>Datenbank anlegen</title>
</head>
<body>
<?php
   /* Datenbank erzeugen */
   $con = new mysqli("localhost", "root", "");
   $sql = "CREATE DATABASE IF NOT EXISTS projektverwaltung";
   $con->execute_query($sql);
   $con->select_db("projektverwaltung");

   /* Tabelle "kunde" erzeugen */
   $sql = "CREATE TABLE IF NOT EXISTS kunde (
      ku_id INT(11) NOT NULL AUTO_INCREMENT,
      ku_name VARCHAR(30) DEFAULT NULL,
      ku_ort VARCHAR(30) DEFAULT NULL,
      PRIMARY KEY (ku_id)
      ) ENGINE=InnoDB DEFAULT CHARSET=UTF8";
   $con->execute_query($sql);

   /* Tabelle "kunde" füllen */
   $sql = "INSERT INTO kunde(ku_id, ku_name, ku_ort) VALUES
      (1, 'Schmidt', 'Hamburg'),
      (2, 'Weber', 'Frankfurt'),
      (3, 'Murchel', 'Dortmund')";
   $con->execute_query($sql);
   
   /* Tabelle "projekt" erzeugen */
   $sql = "CREATE TABLE IF NOT EXISTS projekt (
      pr_id INT(11) NOT NULL AUTO_INCREMENT,
      pr_ku_id INT(11) NOT NULL,
      pr_bezeichnung VARCHAR(50) DEFAULT NULL,
      PRIMARY KEY (pr_id)
      ) ENGINE=InnoDB DEFAULT CHARSET=UTF8";
   $con->execute_query($sql);

   /* Tabelle "projekt" füllen */
   $sql = "INSERT INTO projekt(pr_id, pr_ku_id, pr_bezeichnung) VALUES
      (1, 1, 'Alexanderstrasse'),
      (2, 1, 'Peterstrasse'),
      (3, 2, 'Jahnplatz'),
      (4, 2, 'Lindenplatz'),
      (5, 3, 'Nordbahnhof'),
      (6, 3, 'Westbahnhof')";
   $con->execute_query($sql);
   
   /* Tabelle "person" erzeugen */
   $sql = "CREATE TABLE IF NOT EXISTS person (
      pe_id INT(11) NOT NULL AUTO_INCREMENT,
      pe_nachname VARCHAR(30) DEFAULT NULL,
      pe_vorname VARCHAR(30) DEFAULT NULL,
      PRIMARY KEY (pe_id)
      ) ENGINE=InnoDB DEFAULT CHARSET=UTF8";
   $con->execute_query($sql);

   /* Tabelle "person" füllen */
   $sql = "INSERT INTO person(pe_id, pe_nachname, pe_vorname) VALUES
      (1, 'Mohr', 'Hans'),
      (2, 'Berger', 'Stefan'),
      (3, 'Suhren', 'Marion')";
   $con->execute_query($sql);
  
   /* Tabelle "arbeit" erzeugen */
   $sql = "CREATE TABLE IF NOT EXISTS arbeit (
      ar_id INT(11) NOT NULL AUTO_INCREMENT,
      ar_pr_id INT(11) NOT NULL,
      ar_pe_id INT(11) NOT NULL,
      ar_datum DATE DEFAULT NULL,
      ar_zeit DOUBLE DEFAULT NULL,
      PRIMARY KEY (ar_id)
      ) ENGINE=InnoDB DEFAULT CHARSET=UTF8";
   $con->execute_query($sql);

   /* Tabelle "arbeit" füllen */
   $sql = "INSERT INTO arbeit(ar_id, ar_pr_id, ar_pe_id, ar_datum, ar_zeit) VALUES
      (1, 1, 1, '2022-07-01', 3.5),
      (2, 1, 3, '2022-07-01', 4),
      (3, 4, 1, '2022-07-01', 3),
      (4, 4, 2, '2022-07-01', 6.5),
      (5, 4, 2, '2022-07-02', 7.3),
      (6, 4, 3, '2022-07-01', 4)";
   $con->execute_query($sql);

   $con->close();
?>
</body>
</html>
