<!DOCTYPE html>
<html lang="de">
<head>
   <meta charset="utf-8">
   <title>Projektverwaltung, Personen</title>
   <link rel="stylesheet" type="text/css" href="db_linkcss.css">

<!-- Das Programm zur Verwaltung der Personen hat den gleichen Aufbau wie das Programm zur Verwaltung der Kunden.
     In den Kommentaren in dieser Datei werden nur die Unterschiede erläutert. -->

<script type="text/javascript">
function send(aktion,id)
{
   if(aktion==2)
      if(!confirm("Datensatz mit ID " + id + " entfernen?"))
         return;

   document.f.aktion.value = aktion;
   document.f.id.value = id;
   document.f.submit();
}
</script>

<?php
/* Die Funktion personbereitsvorhanden() wird beim Neueintragen bzw. Ändern von Datensätzen genutzt.
   Falls es bereits eine Person mit den aktuell eingegebenen Daten für Nachname und Vorname gibt, findet die betreffende Aktion nicht statt. */
function personbereitsvorhanden($con, $na, $vo)
{
   $sql = "SELECT * FROM person WHERE pe_nachname = ? AND pe_vorname = ?";
   $res = $con->execute_query($sql, [$na, $vo]);
   $anzahl = $res->num_rows;
   $res->close();
   if($anzahl > 0)
      return true;
   else
      return false;
}
?>
</head>

<body>
<p><a href="db_projektverwaltung.php">Zurück zum Hauptmenü</a></p>
<p>Personen:</p>
<?php
   $con = new mysqli("localhost", "root", "", "projektverwaltung");

   /* In der Tabelle "person" gibt es die Felder "pe_id", "pe_nachname" und "pe_vorname".
      In der Darstellung kann nach ID, Nachname oder Vorname sortiert werden. */
   $od = "ORDER BY pe_id";

   /* Aktion ausführen */
   if(isset($_POST["aktion"]))
   {
      /* Neu eintragen */
      if($_POST["aktion"] == "0")
      {
         if($_POST["na"][0] == "" || $_POST["vo"][0] == "")
            echo "<p style='color:#ff0000;'>Bitte Nachname und Vorname eintragen</p>";
         else if(personbereitsvorhanden($con, $_POST["na"][0], $_POST["vo"][0]))
            echo "<p style='color:#ff0000;'>Person bereits vorhanden</p>";
         else
         {
            $sql = "INSERT INTO person(pe_nachname, pe_vorname) VALUES(?, ?)";
            $con->execute_query($sql, [$_POST["na"][0], $_POST["vo"][0]]);
         }
      }

      /* Ändern */
      else if($_POST["aktion"] == "1")
      {
         $id = $_POST["id"];
         if($_POST["na"][$id] == "" || $_POST["vo"][$id] == "")
            echo "<p style='color:#ff0000;'>Bitte Nachname und Vorname eintragen</p>";
         else if(personbereitsvorhanden($con, $_POST["na"][$id], $_POST["vo"][$id]))
            echo "<p style='color:#ff0000;'>Person bereits vorhanden</p>";
         else
         {
            $sql = "UPDATE person SET pe_nachname=?, pe_vorname=? WHERE pe_id=$id";
            $con->execute_query($sql, [$_POST["na"][$id], $_POST["vo"][$id]]);
         }
      }

      /* Löschen:
         Es wird geprüft, ob es Datensätze in der Tabelle der Arbeitszeiten gibt, die der zu löschenden Person zugeordnet sind.
         Ist das der Fall, kann die Person nicht gelöscht werden, da ansonsten die Verbindung zwischen den Tabellen "person" und "arbeit" verloren gehen würde. */
      else if($_POST["aktion"] == "2")
      {
         $id = $_POST["id"];
         $sql = "SELECT * FROM arbeit WHERE ar_pe_id = $id";
         $res = $con->execute_query($sql);
         $anzahl = $res->num_rows;
         $res->close();

         if($anzahl > 0)
            echo "<p style='color:#ff0000;'>Person hat Arbeitszeiten</p>";
         else
         {
            $sql = "DELETE FROM person WHERE pe_id = $id";
            $con->execute_query($sql);
         }
      }

      /* Sortieren */
      else if($_POST["aktion"] == "3") $od = " ORDER BY pe_id";
      else if($_POST["aktion"] == "4") $od = " ORDER BY pe_nachname";
      else if($_POST["aktion"] == "5") $od = " ORDER BY pe_vorname";
   }

   /* Formularbeginn */
   echo "<form name='f' action='db_projektverwaltung_person.php' method='post'>"
      . "<input name='aktion' type='hidden'>"
      . "<input name='id' type='hidden'>\n\n";

   /* Tabellenbeginn */
   echo "<table>"
      . "<tr>"
      . "<td><a href='javascript:send(3,0);'>ID</a></td>"
      . "<td><a href='javascript:send(4,0);'>Nachname</a></td>"
      . "<td><a href='javascript:send(5,0);'>Vorname</a></td>"
      . "<td>Aktion</td></tr>\n\n";

   /* Neuer Eintrag */
   echo "<tr>"
      . "<td>&nbsp;</td>"
      . "<td><input name='na[0]' size='10'></td>"
      . "<td><input name='vo[0]' size='10'></td>"
      . "<td><a href='javascript:send(0,0);'>neu eintragen</a></td>"
      . "</tr>\n\n";

   /* Anzeigen */
   $sql = "SELECT * FROM person $od";
   $res = $con->execute_query($sql);

   /* Alle vorhandenen Datensätze */
   while($dsatz = $res->fetch_assoc())
   {
      $id = $dsatz["pe_id"];
      $na = $dsatz["pe_nachname"];
      $vo = $dsatz["pe_vorname"];
      echo "<tr>"
         . "<td>$id</td>"
         . "<td><input name='na[$id]' value='$na' size='10'></td>"
         . "<td><input name='vo[$id]' value='$vo' size='10'></td>"
         . "<td><a href='javascript:send(1,$id);'>speichern</a>"
         . " <a href='javascript:send(2,$id);'>entfernen</a></td>"
         . "</tr>\n\n";
   }
   echo "</table></form>";
   $res->close();
   $con->close();
?>
</body></html>
