<!DOCTYPE html>
<html lang="de">
<head>
   <meta charset="utf-8">
   <title>Projektverwaltung, Projekte</title>
   <link rel="stylesheet" type="text/css" href="db_linkcss.css">

<!-- Das Programm zur Verwaltung der Projekte hat den gleichen Aufbau wie das Programm zur Verwaltung der Kunden.
     In den Kommentaren in dieser Datei werden nur die Unterschiede erläutert. -->

<script type="text/javascript">
function send(aktion,id)
{
   if(aktion==2)
      if(!confirm("Datensatz mit ID " + id + " entfernen?"))
         return;

   document.f.aktion.value = aktion;
   document.f.id.value = id;
   document.f.submit();
}
</script>

<?php
/* Die Funktion projektbereitsvorhanden() wird beim Neueintragen bzw. Ändern von Datensätzen genutzt.
   Falls es bereits ein Projekt für den aktuell ausgewählten Kunden und die aktuell eingegebene Projektbezeichnung gibt, findet die betreffende Aktion nicht statt. */
function projektbereitsvorhanden($con, $ku, $be)
{
   $sql = "SELECT * FROM projekt WHERE pr_ku_id = $ku AND pr_bezeichnung = ?";
   $res = $con->execute_query($sql, [$be]);
   $anzahl = $res->num_rows;
   $res->close();
   if($anzahl > 0)
      return true;
   else
      return false;
}
?>
</head>

<body>
<p><a href="db_projektverwaltung.php">Zurück zum Hauptmenü</a></p>
<p>Projekte:</p>
<?php
   $con = new mysqli("localhost", "root", "", "projektverwaltung");

   /* In der Tabelle "projekt" gibt es die Felder "pr_id", "pr_ku_id" und "pr_bezeichnung".
      Das Feld "pr_ku_id" dient zur Verknüpfung mit der Tabelle der Kunden.
      In der Darstellung kann nach ID, Kundenname mit Projektbezeichnung oder nur nach Projektbezeichnung sortiert werden. */
   $od = "ORDER BY pr_id";

   /* Aktion ausführen */
   if(isset($_POST["aktion"]))
   {
      /* Neu eintragen */
      if($_POST["aktion"] == "0")
      {
         if($_POST["be"][0] == "")
            echo "<p style='color:#ff0000;'>Bitte Bezeichnung eintragen</p>";
         else if(projektbereitsvorhanden($con, $_POST["ku"][0], $_POST["be"][0]))
            echo "<p style='color:#ff0000;'>Projekt bereits vorhanden</p>";
         else
         {
            $sql = "INSERT INTO projekt(pr_ku_id, pr_bezeichnung) VALUES(?, ?)";
            $con->execute_query($sql, [$_POST["ku"][0], $_POST["be"][0]]);
         }
      }

      /* Ändern */
      else if($_POST["aktion"] == "1")
      {
         $id = $_POST["id"];
         if($_POST["be"][$id] == "")
            echo "<p style='color:#ff0000;'>Bitte Bezeichnung eintragen</p>";
         else if(projektbereitsvorhanden($con, $_POST["ku"][$id], $_POST["be"][$id]))
            echo "<p style='color:#ff0000;'>Projekt bereits vorhanden</p>";
         else
         {
            $sql = "UPDATE projekt SET pr_ku_id=?, pr_bezeichnung=? WHERE pr_id=$id";
            $con->execute_query($sql, [$_POST["ku"][$id], $_POST["be"][$id]]);
         }
      }

      /* Löschen:
         Es wird geprüft, ob es Datensätze in der Tabelle der Arbeitszeiten gibt, die dem zu löschenden Projekt zugeordnet sind.
         Ist das der Fall, kann das Projekt nicht gelöscht werden, da ansonsten die Verbindung zwischen den Tabellen "projekt" und "arbeit" verloren gehen würde. */
      else if($_POST["aktion"] == "2")
      {
         $id = $_POST["id"];
         $sql = "SELECT * FROM arbeit WHERE ar_pr_id = $id";
         $res = $con->execute_query($sql);
         $anzahl = $res->num_rows;
         $res->close();

         if($anzahl > 0)
            echo "<p style='color:#ff0000;'>Projekt hat Arbeitszeiten</p>";
         else
         {
            $sql = "DELETE FROM projekt WHERE pr_id = $id";
            $con->execute_query($sql);
         }
      }

      /* Sortieren */
      else if($_POST["aktion"] == "3") $od = " ORDER BY pr_id";
      else if($_POST["aktion"] == "4") $od = " ORDER BY ku_name, ku_ort, pr_bezeichnung";
      else if($_POST["aktion"] == "5") $od = " ORDER BY pr_bezeichnung";
   }

   /* Formularbeginn */
   echo "<form name='f' action='db_projektverwaltung_projekt.php' method='post'>"
      . "<input name='aktion' type='hidden'>"
      . "<input name='id' type='hidden'>\n\n";

   /* Tabellenbeginn */
   echo "<table>"
      . "<tr>"
      . "<td><a href='javascript:send(3,0);'>ID</a></td>"
      . "<td><a href='javascript:send(4,0);'>Kunde</a></td>"
      . "<td><a href='javascript:send(5,0);'>Bezeichnung</a></td>"
      . "<td>Aktion</td></tr>\n\n";

   /* Der Name des Kunden muss beim Neueintragen bzw. Ändern eines Projekts aus einer Liste der vorhandenen Kunden ausgewählt werden.
      Dazu werden hier die ID bzw. der Nachname und der Ort der Kunden in den beiden parallel aufgebauten Hilfsfeldern $id_feld und $ku_feld gespeichert.
      Die Inhalte werden in der Darstellung für die einzelnen Optionen des Auswahlmenüs in der Spalte "Kunde" benötigt.
      Soll ein neues Projekt eines neuen Kunden eingetragen werden, muss zunächst der Kunde in der Verwaltung der Kunden eingetragen werden. */
   $sql = "SELECT * FROM kunde";
   $res = $con->execute_query($sql);
   $id_feld = array();
   $ku_feld = array();
   while($dsatz = $res->fetch_assoc())
   {
      array_push($id_feld, $dsatz["ku_id"]);
      array_push($ku_feld, $dsatz["ku_name"] . " (" . $dsatz["ku_ort"] . ")");
   }
   $res->close();

   /* Neuer Eintrag */
   echo "<tr>"
      . "<td>&nbsp;</td>"
      . "<td><select name='ku[0]'>";
   /* Der Name des Kunden muss beim Neueintragen eines Projekts aus einer Liste der vorhandenen Kunden ausgewählt werden. */
   for ($i=0; $i<count($id_feld); $i++)
      echo "<option value='$id_feld[$i]'>$ku_feld[$i]</option>";
   echo "</select></td>"
      . "<td><input name='be[0]' size='15'></td>"
      . "<td><a href='javascript:send(0,0);'>neu eintragen</a></td>"
      . "</tr>\n\n";

   /* Mithilfe der nachfolgenden SQL-Anweisung werden die Inhalte der beiden Tabellen "kunde" und "projekt" miteinander verknüpft.
      Der Anweisungsteil INNER JOIN ... ON sorgt dafür, dass diejenigen Daten der beiden Tabellen miteinander verknüpft werden,
      bei denen die Inhalte der beiden Felder "ku_id" und "pr_ku_id" übereinstimmen.
      Die einzelnen Datensätze des Ergebnisses enthalten anschließend die Daten aller Projekte, zusammen mit den Daten des zugehörigen Kunden. */
   $sql = "SELECT ku_name, ku_ort, pr_id, pr_ku_id, pr_bezeichnung"
      . " FROM kunde INNER JOIN projekt ON kunde.ku_id = projekt.pr_ku_id $od";
   $res = $con->execute_query($sql);

   /* Alle vorhandenen Datensätze */
   while($dsatz = $res->fetch_assoc())
   {
      $id = $dsatz["pr_id"];
      $ku = $dsatz["pr_ku_id"];
      $be = $dsatz["pr_bezeichnung"];
      echo "<tr>"
         . "<td>$id</td>"
         . "<td><select name='ku[$id]'>";
       /* Im Auswahlmenü wird jeweils diejenige Option mithilfe des HTML-Attributs "selected" ausgewählt,
          bei der die ID des Kunden mit dem Element des Feldes $id_feld übereinstimmt. */
      for ($i=0; $i<count($id_feld); $i++)
      {
         echo "<option value='$id_feld[$i]'";
         if($ku == $id_feld[$i])
            echo " selected='selected'";
         echo ">$ku_feld[$i]</option>";
      }
      echo "</select></td>"
         . "<td><input name='be[$id]' value='$be' size='15'></td>"
         . "<td><a href='javascript:send(1,$id);'>speichern</a>"
         . " <a href='javascript:send(2,$id);'>entfernen</a></td>"
         . "</tr>\n\n";
   }
   echo "</table></form>";
   $res->close();
   $con->close();
?>
</body></html>
