<!DOCTYPE html>
<html lang="de">
<head>
   <meta charset="utf-8">
   <title>Mit Exception</title>
</head>
<body>
<?php
   /* Variable unbekannt */
   try
   {
      if(!isset($x))
         throw new Exception("Variable unbekannt<br>");
      echo "Variable: $x<br>";
   }
   catch(Exception $e)
   {
      echo "catch ohne Variable<br>";
   }
   finally
   {
      echo "Ende, Variable unbekannt<br><br>";
   }

   /* Division durch 0 */
   $x = 42;
   $y = 0;
   try
   {
      if($y == 0)
         throw new Exception("Division durch 0<br><br>");
      $z = $x / $y;
      echo "Division: $x / $y = $z<br><br>";
   }
   catch(Exception $e)
   {
      echo $e->getMessage();
   }

   /* Zugriff auf Funktion */
   try
   {
      if(!function_exists("testFunktion"))
         throw new Exception("Funktion unbekannt<br><br>");
      testFunktion();
   }
   catch(Exception $e)
   {
      echo $e->getMessage();
   }

   echo "Ende des Programms";
?>
</body>
</html>
