<!DOCTYPE html>
<html lang="de">
<head>
   <meta charset="utf-8">
   <title>Feld von Objekten sortieren</title>
</head>
<body>
<?php
   class Fahrzeug
   {
      function __construct(private $bezeichnung = "",
         private $geschwindigkeit = 0) { }

      static function vergleich($a, $b)
      {
         if($a->geschwindigkeit < $b->geschwindigkeit)      return -1;
         else if($a->geschwindigkeit > $b->geschwindigkeit) return 1;
         else                                               return 0;
      }

      function __toString()
      {
         return "$this->bezeichnung, $this->geschwindigkeit km/h<br>";
      }
   }

   $feld = array(new Fahrzeug("Opel Astra", 155),
                 new Fahrzeug("Scania TS 360", 62),
                 new Fahrzeug("Vespa Piaggio", 25),
                 new Fahrzeug("VW Golf", 145));

   usort($feld, array("Fahrzeug", "vergleich"));

   foreach($feld as $element)
      echo $element;
?>
</body>
</html>
