<!DOCTYPE html>
<html lang="de">
<head>
   <meta charset="utf-8">
   <title>Forum</title>

<!-- Allgemein:
     Zur Erzeugung der Datenbank mit Tabellen können Sie das PHP-Programm forum_db_neu.php benutzen, Kommentare siehe dort.
     Der Zugang zum Forum ist nur über ein individuelles Passwort möglich.
     Die Teilnehmer erfahren ihr individuelles Passwort als Antwort auf eine E-Mail an den Administrator des Forums.
     Er benutzt zur Erzeugung der Passwörter das PHP-Programm forum_pw.php, Kommentare siehe dort. -->

<!-- CSS-Formatierung:
     Für das Dokument wird die Schriftart "Verdana" in der Größe 10 Punkt eingestellt. Der Hintergrund ist hellblau.
     Für Tabellenzellen wird die gleiche Schriftformatierung gewählt. Die Zellen haben allerdings einen hellgrauen Hintergrund.
     Dadurch wird die Aufteilung der Seite vor dem Dokumenthintergrund stärker hervorgehoben.
     Auf diese Weise hat die CSS-Formatierung nicht nur einen optischen, sondern auch einen funktionellen Charakter.

	 Beiträge erstrecken sich meist über mehrere Zeilen innerhalb einer Zelle.
     Datum, Uhrzeit, Name und Thema dienen durch ihre vertikale Ausrichtung am oberen Rand als optische "Ordner" der Tabellenzeile.
     Tabellenzellen der Klasse "kl" werden für die Angaben von Datum, Uhrzeit und Namen eingesetzt.
     Diese Zellen haben eine etwas kleinere Schrift. Der Eigenschaftswert 10pt wird hier durch den Wert 8pt überlagert.
     Die restlichen Eigenschaften einer Tabellenzelle bleiben erhalten.
     Hyperlinks ändern ihre Schriftfarbe auf Rot, falls man mit dem Mauszeiger über sie fährt. -->
<style type="text/css">
   body      {font-family:Verdana; font-size:10pt; background-color:#d0dce0; color:#00008b}
   td        {font-family:Verdana; font-size:10pt; background-color:#d0d0d0; color:#00008b; vertical-align:top}
   td.ub     {background-color:#d0d0d0}
   td.kl     {font-size:8pt}
   a:link    {color:#0000ff}
   a:visited {color:#0000ff}
   a:hover   {color:#ff0000}
</style>

<script type="text/javascript">
/* Zur Einstellung der gewünschten Aktion bzw. Darstellung.
   Die Funktion wird von verschiedenen Hyperlinks aufgerufen. Der dabei übermittelte Parameter "p" legt die Art der Aktion fest. */
function send(p)
{
   /* Absenden eines neuen Beitrags:
      Ist eines der beiden Elemente für das Thema bzw. den Beitrag leer, wird der Beitrag nicht gesendet.
      Andernfalls wird dem versteckten Element "aufruf" der Wert "beitrag" zugewiesen.
         Dieser Wert wird später ausgewertet. Anschließend wird gesendet. */
   if(p==1)
   {
      if(document.tb.thema.value == "" || document.tb.beitrag.value == "")
         alert("Bitte Thema und Beitrag eintragen!");
      else
      {
         document.tb.aufruf.value = "beitrag";
         document.tb.submit();
      }
   }

   /* Die Tabelle soll nach dem Datum absteigend sortiert werden. Das versteckte Element "aufruf" bekommt den Wert "sdatum". */
   else if(p==2)
   {
      document.tb.aufruf.value = "sdatum";
      document.tb.submit();
   }

   /* Die Tabelle soll nach dem Namen sortiert werden. Das versteckte Element bekommt den Wert "sname". */
   else if(p==3)
   {
      document.tb.aufruf.value = "sname";
      document.tb.submit();
   }

   /* Die Tabelle soll nach dem Thema sortiert werden. Das versteckte Element bekommt den Wert "sthema". */
   else if(p==4)
   {
      document.tb.aufruf.value = "sthema";
      document.tb.submit();
   }

   /* Die Tabelle soll nach dem ausgewählten Thema gefiltert angezeigt werden. Das versteckte Element bekommt den Wert "filter_t". */
   else if(p==5)
   {
      document.tb.aufruf.value = "filter_t";
      document.tb.submit();
   }

   /* Die Tabelle soll nach dem ausgewählten Namen gefiltert angezeigt werden. Das versteckte Element bekommt den Wert "filter_n". */
   else if(p==6)
   {
      document.tb.aufruf.value = "filter_n";
      document.tb.submit();
   }

   /* Die Tabelle soll nach dem eingetragenen Wort gefiltert angezeigt werden. Das versteckte Element bekommt den Wert "filter_w". */
   else if(p==7)
   {
      document.tb.aufruf.value = "filter_w";
      document.tb.submit();
   }
   /* Nach der Durchführung einer der Aktionen 2 bis 7 wird das Formular ebenfalls abgesendet. */
}
</script>
</head>

<!-- Erläuterung der Elemente der Darstellung:

     Überschrift:
     Der Name des angemeldeten Teilnehmers wird angezeigt. Er kann nach der Eingabe des Passworts eindeutig zugeordnet werden.
     
	 Neuen Beitrag eingeben:
     Der Hyperlink führt zum unteren Ende der Seite.
     Dies ist besonders dann sinnvoll, wenn bereits zahlreiche Einträge existieren.
     In der Textarea können das Thema und der Inhalt des neuen Beitrags eingegeben werden.
     Die Bezeichnung des Themas sollte nicht länger als 20 Zeichen sein, und die Länge eines Beitrags ist auf 1.000 Zeichen begrenzt.
     Unter der Textarea steht neben dem Hyperlink "Beitrag senden" der Hyperlink "Nach oben" zum Zurückspringen zum Kopf der Seite.
     Nach dem Senden eines neuen Beitrags wird die Seite neu geladen.
     Dann ist kein Filter aktiv; die Beiträge sind absteigend nach dem Datum sortiert, und der soeben abgesendete Beitrag erscheint oben.
     Die Liste "Filtern nach Thema" wird ergänzt, falls es sich um einen Beitrag zu einem neuen Thema handelt.
     Die Liste "Filtern nach Name" wird ebenfalls ergänzt, falls es sich um den ersten Beitrag dieses Teilnehmers handelt.

	 Abmelden:
     Der Hyperlink führt wieder zum Anmeldebildschirm.

     Filtern nach Thema:
     Die Beiträge des Forums lassen sich gefiltert anzeigen. Die Benutzer können selbst das Thema ihres Beitrags wählen.
     Möchte ein Benutzer nur die Beiträge zu einem bestimmten Thema sehen, kann er das gewünschte Thema aus der Liste auswählen.
     Diese Liste enthält automatisch alle Themen des Forums in alphabetischer Reihenfolge.
     Das Forum kann somit auf einfache Weise in einzelne Foren "zerlegt" werden.
     Diese Funktionalität setzt eine gewisse Benutzerdisziplin bei der Eingabe der Themen voraus,
        die man in einer geschlossenen, namentlich bekannten Benutzergruppe erwarten kann.
     Zusätzlich kann ein Moderator regelmäßig die Liste der Themen "vereinheitlichen", um die Filterung zu erleichtern.

     Filtern nach Name:
     Möchte ein Benutzer nur die Beiträge eines bestimmten Kollegen sehen, kann er den gewünschten Namen aus der Liste auswählen.
     Sie enthält alle Benutzer des Forums, die bereits mindestens einen Beitrag gesendet haben, und zwar in alphabetischer Reihenfolge.

     Filtern nach Wort:
     Das Textfeld bietet eine Volltextsuchfunktion an.
     Nach der Eingabe eines Begriffs werden nur noch die Beiträge angezeigt, die dieses Wort enthalten.
     Dies kann als Ergänzung zu "Filtern nach Thema" angesehen werden,
        denn ein Beitrag lässt sich nicht immer nur einem Thema eindeutig zuordnen.

     Datum:
     Der Hyperlink sortiert die Beiträge nach ihrem Datum; der neueste Beitrag steht oben.
     Dies ist die Standardsortierung nach der Anmeldung.
     Sie wird nur benötigt, wenn vorher eine der beiden anderen Sortierungen genutzt wurde.

     Name bzw. Thema:
     Die beiden Hyperlinks bieten eine alphabetische Sortierung der Beiträge nach dem Benutzernamen bzw. nach dem Thema des Beitrags.

     Es folgen die einzelnen Beiträge gemäß der aktuellen Sortierung, mit Datum, Uhrzeit und Name des beitragenden Teilnehmers.

     Hinweis:
     Die Filter-, Such- und Sortierfunktionen können nur einzeln genutzt werden. Sie sind nicht additiv.
     Es ist also nicht möglich, nur die Beiträge eines Teilnehmers anzuzeigen und diese gleichzeitig nach einem Thema zu sortieren.
     Hier wird einer schnellen Lösung der Vorzug vor einer komplexen Lösung gegeben.
     Die erweiterte Funktionalität könnte hinzugefügt werden, falls sich die Notwendigkeit ergibt. -->

<body>
<?php
/* Die Datenbankverbindung wird aufgenommen. */
$con = new mysqli("localhost", "root", "", "forum");

/* Wird kein Passwort übermittelt oder keine Aktion aufgerufen, wird unmittelbar die Anmeldeseite generiert:
   Diese besteht aus dem Formular mit dem Namen "anm". Das Formular enthält das versteckte Element "aufruf" mit dem
   Wert "login" sowie ein Element zur Eingabe des Passworts. Der Hyperlink dient zum Absenden des Formulars.
   Ansonsten ist die Anmeldeseite leer. Daher kann das Dokument mit "exit" beendet werden. */
if(!isset($_POST["aufruf"]) || !isset($_POST["pw"]))
{
   echo "<form name='anm' action='forum.php' method='post'>Passwort:<br><input type='password' name='pw'>"
     . "<input type='hidden' name='aufruf' value='login'><br><a href='javascript:document.anm.submit();'>Anmelden</a></form></body></html>";
   exit;
}

/* Mithilfe einer SELECT-Anweisung wird ermittelt, ob das Passwort in der Tabelle existiert.
   Wird kein passender Datensatz gefunden, ruft sich das Dokument selbst wieder auf.
   Da dabei keine Parameter übermittelt werden, gelangt man so zur Anmeldeseite zurück. */
$sql = "SELECT vorname, nachname, passwort FROM teilnehmer WHERE passwort = ?";
$res = $con->execute_query($sql, [$_POST["pw"]]);
if($res->num_rows == 0)
{
   $res->close();
   exit("<script type='text/javascript'>location.href='forum.php'</script></body></html>");
}

/* Der Name des Teilnehmers wird aus dem Datensatz ermittelt, in dem das Passwort gefunden wird. */
$dsatz = $res->fetch_assoc();
$ganzername = $dsatz["vorname"] . " " . $dsatz["nachname"];
$res->close();

/* War die Anmeldung erfolgreich, wird das Hauptformular mit dem Namen "tb" begonnen.
   Das erste versteckte Element "pw" übermittelt das Passwort zum nächsten Aufruf weiter, und das zweite versteckte Element "aufruf"
   dient zur Übermittlung der gewünschten Aktion (Sortieren, Filtern, Eintragen usw.) mithilfe der JavaScript-Funktion. */
echo "<form name='tb' action='forum.php' method='post'><input type='hidden' name='pw' value='"
        . $_POST["pw"] . "'><input type='hidden' name='aufruf'>";

/* In der Überschrift erscheint der ermittelte Name des Teilnehmers.
   Es folgt der Hyperlink zum Ankerpunkt "neu" im unteren Teil des Dokuments. */
echo "<table style='width:100%;'><tr><td colspan='4' class='ub'><a name='oben'><b>Fachinformatiker Praktikumsforum,"
  . " $ganzername</b></a></td></tr><tr><td style='width:25%;' class='ub'>"
  . "<a href='#neu'>Neuen Beitrag eingeben</a><br>&nbsp;<br><a href='forum.php'>Abmelden</a></td>";

/* Ein neuer Beitrag wird als Erstes gespeichert, sodass ihn das restliche Dokument miteinbeziehen kann.
   Wird ein Beitrag gesendet, hat die Variable $aufruf den Wert "beitrag".
   Der neue Beitrag wird eingetragen, mit dem vollen Namen des Teilnehmers, dem Thema und dem Beitrag selbst.
   Für das Datenbankfeld vom Typ "Timestamp" wird automatisch die aktuelle Systemzeit ermittelt und eingetragen. */
if($_POST["aufruf"] == "beitrag")
{
   $sql = "INSERT INTO eintrag (name, thema, beitrag) VALUES ('$ganzername', ?, ?)";
   $con->execute_query($sql, [$_POST["thema"], $_POST["beitrag"]]);
}

/* Auswahlliste der Themen, zum Filtern nach Thema:
   Mit SELECT werden alle Themen gesammelt, die bereits eingegeben wurden.
   Die Klausel GROUP BY sorgt dabei für eine Gruppierung. Dadurch wird jedes Thema im Abfrageergebnis nur einmal aufgeführt. */
$sql = "SELECT thema FROM eintrag GROUP BY thema";
$res = $con->execute_query($sql);

/* Mit den Daten des Abfrageergebnisses wird die Liste "filter_t" gefüllt.
   Als erste Option der Optionsliste wird "- alle -" eingetragen.
   Wird kein anderes Listenelement ausgewählt, werden alle Beiträge angezeigt; die Filterung wird dadurch aufgehoben.
   Unterhalb der Liste wird der zugehörige Hyperlink "Anzeigen" dargestellt.
   Durch seine Betätigung wird die JavaScript-Funktion send() mit dem Parameter "5" aufgerufen.
   Dadurch wird dem versteckten Element "aufruf" der Wert "filter_t" zugewiesen,
      sodass beim anschließenden Neuanzeigen der Tabelle dieser Filter genutzt wird. */
echo "<td style='width:25%;' class='ub'>Filtern nach Thema:<br>"
  . "<select name='filter_t'><option value='- alle -'>- alle -</option>";
while($dsatz = $res->fetch_assoc())
   echo "<option value='" . $dsatz["thema"] . "'>" . $dsatz["thema"] . "</option>";
echo "</select><br><a href='javascript:send(5);'>anzeigen</a></td></td>";
$res->close();

/* Auswahlliste der Namen, zum Filtern nach Namen:
   Auf die gleiche Weise wird die Liste "filter_n" mit den Namen der Teilnehmer gefüllt, die bereits etwas eingegeben haben.
   Die Funktion send() wird mit dem Parameter "6" aufgerufen; "aufruf" bekommt dadurch den Wert "filter_n". */
$sql = "SELECT name FROM eintrag GROUP BY name";
$res = $con->execute_query($sql);

echo "<td style='width:25%;' class='ub'>Filtern nach Name:<br>"
  . "<select name='filter_n'><option value='- alle -'>- alle -</option>";
while($dsatz = $res->fetch_assoc())
   echo "<option value='" . $dsatz["name"] . "'>" . $dsatz["name"] . "</option>";
echo "</select><br><a href='javascript:send(6);'>anzeigen</a></td></td>";
$res->close();

/* Eingabefeld für ein Suchwort, zum Filtern nach dem Suchwort:
   Für das gesuchte Wort steht das Eingabeelement "filter_w" bereit.
   Darunter wird wiederum der zugehörige Hyperlink "Anzeigen" dargestellt.
   Die Funktion send() wird mit dem Parameter "7" aufgerufen; "aufruf" bekommt dadurch den Wert "filter_w". */
echo "<td style='width:25%;' class='ub'>Filtern nach Wort:<br><input name='filter_w'><br>"
  . "<a href='javascript:send(7);'>anzeigen</a></td></tr></table>";

/* Erstellung der SQL-Anweisung in Abhängigkeit der gewünschten Sortierung:
   Es werden alle Beiträge dargestellt, sortiert nach Zeit (absteigend).
   Wird eine Sortierung nach Datum gewünscht, wird ein neuer Beitrag eingegeben oder
   hat sich ein Teilnehmer angemeldet, wird die Standardsortierung durchgeführt: Der neueste Beitrag steht oben. */
if($_POST["aufruf"] == "sdatum" || $_POST["aufruf"] == "beitrag" || $_POST["aufruf"] == "login")
{
   $sql = "SELECT zeit, name, thema, beitrag FROM eintrag ORDER BY zeit DESC";
   $res = $con->execute_query($sql);
}

/* Es werden alle Beiträge dargestellt, sortiert nach Name (aufsteigend) und Zeit (absteigend). */
else if($_POST["aufruf"] == "sname")
{
   $sql = "SELECT zeit, name, thema, beitrag FROM eintrag ORDER BY name ASC, zeit DESC";
   $res = $con->execute_query($sql);
}

/* Es werden alle Beiträge dargestellt, sortiert nach Thema (aufsteigend) und Zeit (absteigend). */
else if($_POST["aufruf"] == "sthema")
{
   $sql = "SELECT zeit, name, thema, beitrag FROM eintrag ORDER BY thema ASC, zeit DESC";
   $res = $con->execute_query($sql);
}

/* Erstellung der SQL-Anweisung in Abhängigkeit der gewünschten Filterung:
   Zunächst wird untersucht, ob die erste Option "- alle -" ausgewählt ist. In diesem Fall werden alle Beiträge angezeigt.
   Andernfalls gilt der Wert des Auswahlmenüs "filter_t" als Wert für die WHERE-Klausel und
      es werden nur Beiträge zum ausgewählten Thema dargestellt, sortiert nach Zeit (absteigend). */
else if($_POST["aufruf"] == "filter_t")
{
   if($_POST["filter_t"] == "- alle -")
   {
      $sql = "SELECT zeit, name, thema, beitrag FROM eintrag ORDER BY zeit DESC";
      $res = $con->execute_query($sql);
   }
   else
   {
      $sql = "SELECT zeit, name, thema, beitrag FROM eintrag WHERE thema = ? ORDER BY zeit DESC";
      $res = $con->execute_query($sql, [$_POST["filter_t"]]);
   }
}

/* Zunächst wird auch hier untersucht, ob die erste Option "- alle -" ausgewählt ist. In diesem Fall werden alle Beiträge angezeigt.
   Andernfalls werden nur Beiträge zum ausgewählten Namen dargestellt, sortiert nach Zeit (absteigend). */
else if($_POST["aufruf"] == "filter_n")
{
   if($_POST["filter_n"] == "- alle -")
   {
      $sql = "SELECT zeit, name, thema, beitrag FROM eintrag ORDER BY zeit DESC";
      $res = $con->execute_query($sql);
   }
   else
   {
      $sql = "SELECT zeit, name, thema, beitrag FROM eintrag WHERE name = ? ORDER BY zeit DESC";
      $res = $con->execute_query($sql, [$_POST["filter_n"]]);
   }
}

/* Soll nach einem eingegebenen Wort gefiltert werden, wird zunächst untersucht, ob eventuell kein Zeichen eingegeben wurde.
   In diesem Fall werden ebenfalls wieder alle Beiträge angezeigt.
   Andernfalls gilt der Wert des Eingabeelements "filter_w", umrahmt von zwei Prozentzeichen, als Wert für die WHERE-Klausel.
   Die Prozentzeichen stehen als Platzhalter für beliebig viele beliebige Zeichen.
   Es ist also nicht wichtig, an welcher Stelle das gesuchte Wort im Beitrag steht.
   Es werden nur Beiträge dargestellt, die das eingegebene Wort enthalten, sortiert nach Zeit (absteigend). */
else if($_POST["aufruf"] == "filter_w")
{
   if($_POST["filter_w"] == "")
   {
      $sql = "SELECT zeit, name, thema, beitrag FROM eintrag ORDER BY zeit DESC";
      $res = $con->execute_query($sql);
   }
   else
   {
      $sql = "SELECT zeit, name, thema, beitrag FROM eintrag WHERE beitrag LIKE ? ORDER BY zeit DESC";
      $filter_w = "%" . $_POST["filter_w"] . "%";
      $res = $con->execute_query($sql, [$filter_w]);
   }
}
?>

<!-- Die drei Hyperlinks zur Auswahl der Sortierung rufen die JavaScript-Funktion send() auf, mit den folgenden Parametern:
     2: Sortierung nach Datum, "aufruf=sdatum"
     3: Sortierung nach Name, "aufruf=sname"
     4: Sortierung nach Thema, "aufruf=sthema". -->
<table style="width:100%;">
<tr>
   <td style="width:15%;" class="ub">
      <a href="javascript:send(2);"><b>Datum</a> /
      <a href="javascript:send(3);">Name</b></a>
   </td>
   <td style="width:15%;" class="ub">
      <a href="javascript:send(4);"><b>Thema</b></a>
   </td>
   <td style="width:70%;" class="ub">
      <b>Beitrag</b>
   </td>
</tr>

<?php
/* In der Tabelle folgen die Beiträge – ggf. sortiert bzw. gefiltert.
   Die Ergebnisse der zuvor auf unterschiedliche Weise erstellten und ausgeführten SQL-Anweisung werden ausgegeben.
   Dabei wird der Inhalt des Datenbankfelds vom Typ "Timestamp" formatiert. */
while($dsatz = $res->fetch_assoc())
{
   $zeit = $dsatz["zeit"];
   $name = $dsatz["name"];
   $thema = $dsatz["thema"];
   $beitrag = $dsatz["beitrag"];
   $zeit_ausgabe = mb_substr($zeit,8,2) . "." . mb_substr($zeit,5,2) . "." . mb_substr($zeit,2,2) . " " . mb_substr($zeit,11,5);
   echo "<tr><td class='kl'>$zeit_ausgabe<br>$name</td><td>$thema</td><td>$beitrag</td></tr>";
}
$res->close();
$con->close();
?>
</table>

<!-- Eingabeformular für einen neuen Beitrag:
     Es wird ein einzeiliges Textfeld für das Thema und eine Textarea für den Beitrag dargestellt. Weitere Daten werden nicht benötigt.
     Der Timestamp wird in der Datenbank erzeugt, und der Name des Teilnehmers ist nach der Anmeldung bekannt.
     Der Hyperlink "Beitrag senden" ruft die Funktion send() mit dem Parameter "1" auf: "aufruf=beitrag". -->
<table style="width:100%;">
<tr>
<td style="width:100%;" class="ub">
   <a name="neu"><b>Neuen Beitrag eingeben:</b></a><br>&nbsp;<br>
   Thema (max. 20 Zeichen):<br><input name="thema" size="30" maxlength="20"><br>&nbsp;<br>
   Beitrag:<br><textarea name="beitrag" rows="10" cols="70"></textarea><br>&nbsp;<br>
   <a href="javascript:send(1);">Beitrag senden</a> &nbsp; &nbsp;
   <a href="#oben">Nach oben</a><br>&nbsp;<br>
</td>
</tr>
</table>

</form>
</body>
</html>
