<!DOCTYPE html>
<html lang="de">
<head>
   <meta charset="utf-8">
   <title>Forum, Datenbank neu</title>
</head>
<body>
<?php
   $con = new mysqli("localhost", "root", "");
   $sql = "CREATE DATABASE IF NOT EXISTS forum";
   $con->execute_query($sql);
   $con->select_db("forum");

   /* Die Beiträge werden in der Tabelle "eintrag" gespeichert.
      Neben der eindeutigen ID werden Datum und Uhrzeit, Name des Teilnehmers sowie Thema und Inhalt des Beitrags festgehalten.
      Die Einträge im Feld "id" werden automatisch hochgezählt (Attribut AUTO_INCREMENT).
      Der Eintrag im Feld "zeit" erfolgt ebenfalls automatisch (Datentyp TIMESTAMP). */
   $sql = "CREATE TABLE IF NOT EXISTS eintrag (
      id INT(11) NOT NULL AUTO_INCREMENT,
      zeit TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
      name VARCHAR(40) NOT NULL,
      thema VARCHAR(20) NOT NULL,
      beitrag VARCHAR(1000) NOT NULL,
      PRIMARY KEY (id)
      ) ENGINE=InnoDB DEFAULT CHARSET=UTF8";
   $con->execute_query($sql);

   $sql = "INSERT INTO eintrag (zeit, name, thema, beitrag) VALUES
      ('2022-06-15 14:23:29', 'Theo Scheller', 'PHP', 'Hallo Leute, in meinem Betrieb wird viel mit PHP programmiert. Wie sieht es bei Euch aus?'),
      ('2022-06-15 14:24:24', 'Wolfgang Petersen', 'PHP', 'Hallo Theo, bei uns ist eher Python angesagt.'),
      ('2022-06-15 14:25:59', 'Astrid Gerth', 'Treffen', 'Hallo, was macht Ihr Freitag 16 Uhr? Wir gehen zum Markt.'),
      ('2022-06-15 14:26:37', 'Markus Maier', 'Treffen', 'Gute Idee, ich bin dabei.')";
   $con->execute_query($sql);

   /* Zu jedem Teilnehmer werden ID, Vorname, Nachname und Passwort gespeichert. Auf dem Feld "id" liegt ein Primärschlüssel.
      Die Passwörter werden in diesem Beispielprojekt ausnahmsweise unverschlüsselt in der Datenbank abgelegt.
      In einer möglichen Weiterentwicklung des Projekts würde dies geändert werden.
      Die Pflege der Teilnehmertabelle geschieht durch den Administrator des Forums mithilfe von phpMyAdmin. */
      $sql = "CREATE TABLE IF NOT EXISTS teilnehmer (
      id int(11) NOT NULL,
      vorname VARCHAR(20) NOT NULL,
      nachname VARCHAR(20) NOT NULL,
      passwort VARCHAR(6) NOT NULL,
      PRIMARY KEY (id)
      ) ENGINE=InnoDB DEFAULT CHARSET=UTF8";
   $con->execute_query($sql);

   $sql = "INSERT INTO teilnehmer (id, vorname, nachname, passwort) VALUES
      (1, 'Markus', 'Maier', 'krt956'),
      (2, 'Theo', 'Scheller', 'pth620'),
      (3, 'Wolfgang', 'Petersen', 'ikr652'),
      (4, 'Astrid', 'Gerth', 'hkw649')";
   $con->execute_query($sql);

   $con->close();
?>
</body>
</html>
