<!DOCTYPE html>
<html lang="de">
<head>
   <meta charset="utf-8">
   <title>Forum, Passwörter neu</title>
</head>

<!-- Für jeden Teilnehmer wird hier ein eindeutiges Passwort erzeugt, das aus drei Kleinbuchstaben und drei Ziffern besteht.
     Dadurch ergeben sich circa 17,5 Millionen verschiedene mögliche Kombinationen.
     Das Passwort ist fest, es kann nicht vom Teilnehmer geändert werden. Dies erscheint zunächst als Nachteil, aber:
     - Durch die zufällige Auswahl werden Passwörter festgelegt, die nur schwer erraten werden können.
     - Es wird vermieden, dass die Teilnehmer eigene Passwörter auswählen, die eventuell zu einfach sind.
     - Der Aufwand bei der Anmeldung ist geringer.
     Dieses Programm setzt die Existenz der Tabelle "teilnehmer" voraus.

     Sie sollten das Programm nach einem Lauf auskommentieren oder umbenennen,
        damit die vergebenen Passwörter nicht versehentlich durch neue Zufallswerte überschrieben werden. -->

<body>
<?php
   $con = new mysqli("localhost", "root", "", "forum");

   $passwort = array();
   $anzahl = 0;
   for($i=0; $i<4; $i++)
   {
      do
      {
         /* Für jeden Datensatz werden zwei for-Schleifen durchlaufen.
            Für ein Passwort wird eine Kombination aus drei Kleinbuchstaben und drei Ziffern ermittelt und in einem Feld gespeichert. 
            Dazu wird für die Buchstaben eine zufällige ganze Zahl zwischen 97 und 122 erzeugt.
            Das Zeichen mit der betreffenden Codenummer wird dem Passwort hinzugefügt.
            Die Erzeugung der drei Ziffern verläuft analog. Die Ziffern liegen im Codebereich zwischen 48 und 57. */
         $neu = "";
         for($k=1; $k<=3; $k++)
            $neu .= mb_chr(random_int(97,122));
         for($k=1; $k<=3; $k++)
            $neu .= mb_chr(random_int(48,57));
      }
      /* Mithilfe der Funktion array_search() wird geprüft, ob das neue Passwort bereits im Feld vorhanden ist.
         Trifft das zu, wird die do-while-Schleife, in der die Ermittlung eines Passworts eingebettet ist, noch einmal durchlaufen. */
      while(array_search($neu, $passwort) !== false);

      /* Das Passwort wird zur Kontrolle auf dem Bildschirm ausgegeben und dem Feld hinzugefügt. */
      echo "$i: $neu<br>";
      array_push($passwort, $neu);

      /* Die Datensätze der Datenbanktabelle werden mit den Elementen des Felds aktualisiert.
         Zur Kontrolle wird die Anzahl der vorgenommenen Änderungen ermittelt und am Ende ausgegeben. */
      $sql = "UPDATE teilnehmer SET passwort = '$passwort[$i]' WHERE id = " . ($i+1);
      $con->execute_query($sql);
      $anzahl += $con->affected_rows;
   }

   $con->close();
   echo "Betroffen: $anzahl";
?>
</body>
</html>
