<!DOCTYPE html>
<html lang="de">
<head>
   <meta charset="utf-8">
   <title>Geldanlage, Auswertung</title>
   <style>
      table,td {border:1px solid black;}
   </style>
</head>
<body>
<h2>Geldanlage</h2>

<?php
   /* Umwandlung der Eingaben in Fließkommawerte */
   $betrag = floatval($_POST["grundbetrag"]);
   $laufzeit = floatval($_POST["laufzeit"]);

   /* Ausgabe zur Kontrolle */
   echo "<p>Grundbetrag: $betrag €<br>";
   echo "Laufzeit: $laufzeit Jahre<br>";

   /* Mehrfache Verzweigung zur Ermittlung des Zinssatzes in Abhängigkeit der Laufzeit */
   if($laufzeit <= 3)         $zinssatz = 3;
   else if($laufzeit <= 5)    $zinssatz = 4;
   else if($laufzeit <= 10)   $zinssatz = 5;
   else                       $zinssatz = 6;

   /* Ausgabe zur Kontrolle */
   echo "Zinssatz: $zinssatz %</p>";
?>

<table>
<tr>
  <td style="text-align:right;"><b>nach Jahr</b></td>
  <td style="text-align:right;"><b>Betrag</b></td>
</tr>

<?php
   /* Für jedes Jahr der Geldanlage gibt es einen Durchlauf der for-Schleife.
      Jedes Jahr wird der aktuelle Gesamtbetrag berechnet, formatiert und ausgegeben. */
   for($i=1; $i<=$laufzeit; $i++)
   {
      echo "<tr>";
      echo "<td style='text-align:right;'>$i</td>";
      $betrag += $betrag * $zinssatz / 100;
      $ausgabe = number_format($betrag,2,",",".");
      echo "<td style='text-align:right;'>$ausgabe €</td>";
      echo "</tr>";
   }
?>
</table>
</body>
</html>
