<!DOCTYPE html>
<html lang="de">
<head>
   <meta charset="utf-8">
   <title>Aktienkurs</title>
</head>
<body>
<?php
   /* Es wird eine Grafik der Größe 400 × 400 Pixel erzeugt. */
   $im = imagecreate(400,400);

   /* Die Farben Grau (Hintergrund), Schwarz (Gitternetz und Beschriftung) und Rot (Kursverlauf)
      werden zur Farbpalette der Grafik hinzugefügt. Die TrueType-Schriftart Arial wird eingeführt. */
   $grau = imagecolorallocate($im, 192, 192, 192);
   imagefill ($im, 0, 0, $grau);
   $s = imagecolorallocate($im, 0, 0, 0);
   $r = imagecolorallocate($im, 255, 0, 0);
   $schriftart = $_SERVER["DOCUMENT_ROOT"] . "/arial.ttf";

   /* In der Variablen $ds wird das Enddatum für den Kursverlauf festgelegt.
      Dieses würde im Normalfall aus dem Systemdatum (Kursverlauf bis heute) oder
      aus einer Benutzereingabe (Kursverlauf bis zum ausgewählten Tag) generiert werden.
      Das Datum wird mit der Funktion mktime() in das Datumsformat konvertiert, mit dem PHP arbeiten und rechnen kann.
      Aus dem Enddatum wird mit der Funktion strtotime() das Startdatum (35 Tage = 5 Wochen vorher) erzeugt. */
   $ds = "28.02.2022";
   $datum = mktime(0, 0, 0, mb_substr($ds,3,2), mb_substr($ds,0,2), mb_substr($ds,6,4));
   $datum = strtotime("-35 day", $datum);

   /* Die Werte für den Kursverlauf werden in ein Feld geschrieben. Der Startwert ist 25.
      Die per Zufallszahlengenerator erzeugten Änderungswerte liegen zwischen +3 und –3 pro Tag,
      wobei der Kurs nicht unter den Wert 1 fallen kann.
      Die Kurswerte würden, wie bereits erwähnt, im Normalfall aus einer Datenbank in das Feld geschrieben. */
   $kurs[0] = 25;
   for($i=1; $i<36; $i++)
   {
      $kurs[$i] = $kurs[$i-1] + random_int(-3,3);
      if($kurs[$i]<1)
         $kurs[$i] = 1;
   }

   /* Gitternetz und Beschriftung werden mithilfe einer Schleife erstellt. Es werden:
      - sechs senkrechte Gitternetzlinien zur Datumsorientierung gezeichnet,
      - sechs Beschriftungen für die y-Achse (Kurswerte 0 bis 50) gesetzt,
      - sechs waagerechte Gitternetzlinien zur Orientierung gezeichnet,
      - sechs Beschriftungen für die x-Achse gesetzt und
      - das Datum um sieben Tage erhöht. */
   for($i=0; $i<6; $i++)
   {
      imageline($im, 30, 30 + $i * 340/5, 370, 30 + $i * 340/5, $s);
      imagettftext($im, 11, 0, 375, 30 + $i * 340/5, $s, $schriftart, 50-$i*10);
      imageline($im, 30 + $i * 340/5, 30, 30 + $i * 340/5, 370, $s);
      imagettftext($im, 11, 0, 12 + $i * 340/5, 385, $s,
         $schriftart, date("d.m.",$datum));
      $datum = strtotime("+7 day", $datum);
   }

   /* Mithilfe einer weiteren Schleife werden 35 Linien für die Darstellung des Kursverlaufs gezogen.
      Eine Linie erstreckt sich jeweils vom Kurswert eines Tages zum Kurswert des nächsten Tages. */
   for($i=0; $i<35; $i++)
      imageline($im, 30 + $i * 340/35, 370 - $kurs[$i] * 340/50,
         30 + ($i+1) * 340/35, 370 - $kurs[$i+1] * 340/50, $r);

   /* Die Grafik wird gezeichnet, und der Speicher wird freigegeben. */
   imagejpeg($im, "im_test.jpg");
   imagedestroy($im);
?>
<img src="im_test.jpg" alt="[Bild]">
</body>
</html>
