<!DOCTYPE html>
<html lang="de">
<head>
   <meta charset="utf-8">
   <title>Captcha, Eingabe</title>
</head>
<body>
<?php
   /* Es wird ein Bild der Größe 250 × 60 Pixel erzeugt, das mit einem hellgrauen Hintergrund gefüllt wird.
      Die Farbe für die Zeichen wird auf Schwarz gestellt. */
   $im = imagecreate(250, 60);
   $grau = imagecolorallocate($im, 192, 192, 192);
   imagefill($im, 0, 0, $grau);
   $schwarz = imagecolorallocate($im, 0, 0, 0);
 
   /* Eine Zeichenkette wird mit den möglichen darstellbaren Zeichen gefüllt.
      Dabei werden einige leicht verwechselbare Kombinationen von Zeichen weggelassen, zum Beispiel M und W, O und 0 oder 6 und 9.
      Die verbleibenden Ziffern werden doppelt aufgeführt, sodass die Wahrscheinlichkeit ihrer zufälligen Auswahl ansteigt. */
   $alle = "ABCDEFGHIJKLPQRSTUVXY12345781234578";

   /* Die Zeichen der Zeichenkette werden gemischt. */
   $alle = str_shuffle($alle);

   /* Ihre einzelnen Zeichen werden in einem Feld gespeichert. */
   $feld = mb_str_split($alle);
   
   /* Die ersten fünf Zeichen der Zeichenkette, also die ersten fünf Elemente des Felds enthalten den Text des Captchas.
      Innerhalb einer Schleife werden diese fünf Elemente ausgegeben.
      Die Schleifenvariable wird dabei für die Berechnung der Position und
      des individuellen Drehwinkels eines einzelnen Zeichens genutzt. */
   for($i=1; $i<=5; $i++)
   {
      $schriftart = $_SERVER["DOCUMENT_ROOT"] . "/arial.ttf";
      /* Parameter: Referenz, Schriftgröße, Winkel, x, y, Farbe, Schrift, Text */
      imagettftext ($im, 30, -35 * $i, 45 * $i - 20, 40 - $i * 6, $schwarz, $schriftart, $feld[$i-1]);
   }
 
   /* Das Grafikobjekt wird in der Datei captcha.png gespeichert.
      Diese Datei wird innerhalb des nachfolgenden Formulars angezeigt. */
   imagepng($im, "im_captcha.png");
   imagedestroy($im);

   /* Es folgt die Ausgabe eines Formulars.
      Darin gibt es ein verstecktes Feld, in dem der Text des Captchas übermittelt wird.
      Er wird mithilfe der Funktion password_hash() verschlüsselt, sodass er nicht im Quelltext der Internetseite erkannt werden kann.
      Außerdem gibt es ein Eingabefeld für den Benutzer.
      Nach dem Absenden des Formulars erscheint die zweite Seite mit einer Bestätigung oder einer Ablehnung. */
   echo "<form action='im_captcha_b.php' method='post'>";
   echo "<p>Bitte geben Sie die Zeichen auf dem Bild ein<br>und senden Sie das Formular ab:</p>";
   echo "<input name='bildtext' type='hidden' value='" . password_hash(substr($alle,0,5), PASSWORD_DEFAULT) . "'>";
   echo "<p><img src='im_captcha.png' alt='[Bild]'></p>";
   echo "<p><input name='eingabe'> <input type='submit'></p>";
   echo "</form>";
?>
</body>
</html>
