<!DOCTYPE html>
<html lang="de">
<head>
   <meta charset="utf-8">
   <title>Kopfrechnen, Aufgaben</title>
</head>

<!-- Es gibt eine Klasse "Spiel", deren Definition in eine eigene Datei ausgelagert ist.
     Von dieser Klasse wird ein einzelnes Objekt erzeugt, das alle Daten des Spiels enthält.
     Es wird im ersten Teil der Anwendung serialisiert und im zweiten Teil der Anwendung wieder deserialisiert.

     Eine Eigenschaft der Klasse "Spiel" sind verschiedene Objekte der Klasse "Aufgabe".
     Die Definition der Klasse "Aufgabe" wird ebenfalls in eine Datei ausgelagert.
     Die Anzahl der Aufgaben und damit die Anzahl der Aufgabenobjekte bestimmt der Benutzer zu Beginn des Spiels.
     Die Aufgabenobjekte werden als Eigenschaften des Spielobjekts gemeinsam mit diesem Objekt serialisiert. -->

<body>
<?php
  /* Die beiden Dateien mit den Definitionen der Klassen "Spiel" und "Aufgabe" werden eingebunden. */
  include "kopfoop_spiel.inc.php";
  include "kopfoop_aufgabe.inc.php";
  
  /* Es wird ein neues Spielobjekt erzeugt.
     Der Konstruktor benötigt vier Parameter:
     - den Namen des Spielers,
     - die Anzahl der Aufgaben,
     - den Namen der Startdatei und
     - den Namen der Auswertungsdatei */
  $s = new Spiel(htmlentities($_POST["spielername"]), $_POST["anzahl"], "kopfoop.htm", "kopfoop_b.php");

  /* Das Spielobjekt mit der Aufgabenstellung wird angezeigt. */
  $s->anzeigen();

  /* Die bisher bekannten Daten des Objekts werden mithilfe der Serialisierung gespeichert,
     damit sie später vom Auswertungsprogramm gelesen werden können. */
  $s->speichern();
?>
</body>
</html>
