<?php
class Spiel
{
   /* Die Klasse "Spiel" besitzt insgesamt sechs Eigenschaften.
      Vier davon werden als Parameter bei der Erzeugung eines Spielobjekts übergeben:
      - der Spielername,
      - die Anzahl der Aufgaben,
      - der Name der Startdatei und
      - der Name der Auswertungsdatei
      Die letzten beiden Eigenschaften:
      - die Anzahl der richtig gelösten Aufgaben (Startwert 0) und
      - ein Feld für die einzelnen Aufgaben */
   function __construct(private $spieler = "", private $anzahl = 0, private $start = "",
      private $ziel = "", private $richtig = 0, private $aufgabe = array()) { }

   /* Die Methode anzeigen() dient zur Anzeige aller Aufgaben des Spiels.  */
   function anzeigen()
   {
      /* Es wird geprüft, ob ein Spielername eingetragen wurde.
         Ist dies nicht der Fall, wird nur noch ein Link zur Startdatei angezeigt. */
      echo "<p><b>Kopfrechnen</b></p>";
      if($this->spieler == "")
      {
         echo "<p>Kein Name, kein Spiel</p>";
         echo "<a href='$this->start'>Zum Start</a>";
         return;
      }

      /* Das Ziel des Formulars ist die Auswertungsdatei. */
      echo "<form action='$this->ziel' method='post'>";
      echo "<p>Hallo <b>$this->spieler</b>, Ihre Aufgaben:</p>";

      /* Es wird eine Schleife entsprechend der gewünschten Anzahl an Aufgaben durchlaufen.
         Bei jedem Durchlauf wird ein neues Aufgabenobjekt erzeugt.
         Um die Einzelheiten jeder Aufgabe (Tabellenzeile, Eingabefeld) kümmert sich die Klasse "Aufgabe".
         Die Referenz auf das Aufgabenobjekt wird in das Feld eingegliedert, das eine Eigenschaft des Spielobjekts ist.
         Somit sind alle Aufgabenobjekte dem Spielobjekt zugeordnet und können später gemeinsam mit diesem gespeichert werden.  */
      echo "<table>";
      for($i=1; $i<=$this->anzahl; $i++)
         $this->aufgabe[$i] = new Aufgabe($i, $this->anzahl);
      echo "</table>";

      echo "<p><input type='submit' value='Fertig'></p>";
      echo "</form>";
   }

   /* In der Methode speichern() wird das Spielobjekt inklusive aller Aufgaben serialisiert.
      Die sich ergebende Zeichenkette wird in einer Datei gespeichert. */
   function speichern()
   {
      $zk = serialize($this);
      file_put_contents("kopfoop.dat", $zk);
      /* Ein Nachteil dieser Art der Serialisierung soll nicht unerwähnt bleiben:
         Die Datei mit den Objektdaten hat immer den gleichen Namen.
         Spielen also mehrere Benutzer gleichzeitig, kann es passieren, dass die Objektdaten falsch zugeordnet werden.
         Wenn Sie im Dateinamen Session-Informationen festhalten würden, ließe sich dieses Problem aber auch lösen. */
   }

   /* In der Methode auswerten() werden die Eingaben ausgewertet und das Ergebnis angezeigt. */
   function auswerten($eingabe)
   {
      echo "<p><b>Kopfrechnen</b></p>";
      echo "<p>Hallo <b>$this->spieler</b>, Ihr Ergebnis:</p>";

      /* Die Anzahl der richtig gelösten Aufgaben wird mithilfe des Rückgabewerts der Methode pruefen() errechnet.
         Dieser ist entweder 0 oder 1. Die Methode wird für jede Aufgabe des Spiels aufgerufen.
         Als Parameter wird dabei die Eingabe des Benutzers übergeben, die zuvor in eine Zahl umgewandelt wird. */
      for($i=1; $i<=$this->anzahl; $i++)
         $this->richtig += $this->aufgabe[$i]->pruefen(floatval($eingabe[$i]));

      /* Ausgabe des Ergebnisses */
      echo "<p>$this->richtig von $this->anzahl richtig</p>";
   }
}
?>
