<?php
class Highscore
{
   function __construct(private $spieler = "", private $dauer = 0)
   {
      /* Es wird geprüft, ob die SQLite-Datenbankdatei kopfsq3.db existiert.
         Ist das nicht der Fall, wird die Datenbankdatei neu erzeugt und mit einer neuen Tabelle bestückt.
         Ansonsten wird nur die Verbindung zur Datenbankdatei aufgenommen. */
      if(!file_exists("kopfsq3.db"))
      {
         $db = new SQLite3("kopfsq3.db");
         $db->exec("CREATE TABLE highscore(name TEXT, zeit REAL)");
      }
      else
         $db = new SQLite3("kopfsq3.db");

      /* Mithilfe eines Prepared Statements wird ein neuer Datensatz
         mit dem eingegebenen Namen des Spielers und seiner Spieldauer hinzugefügt. */
      $ps = $db->prepare("INSERT INTO highscore (name, zeit) VALUES (@sp, $this->dauer)");
      $ps->bindParam("@sp", $this->spieler, SQLITE3_TEXT);  
      $ps->execute();
      $db->close();

      $this->anzeigen();
   }

   function anzeigen()
   {
      echo "<p><b>Highscore:</b></p>";
      echo "<p><table>";
      echo "<tr><td><b>Name</b></td><td><b>Zeit</b></td></tr>";

      /* Abruf und Anzeige der maximal zehn besten Ergebnisse aus der Tabelle der Datenbankdatei. */
      $db = new SQLite3("kopfsq3.db");
      $res = $db->query("SELECT * FROM highscore ORDER BY zeit LIMIT 10");
      while($dsatz = $res->fetchArray())
         echo "<tr><td>" . $dsatz["name"] . "</td><td style='text-align:right;'>"
            . number_format($dsatz["zeit"],1) . " Sek.</td></tr>";

      /* Die Verbindung zur Datenbankdatei wird wieder geschlossen. */
      $db->close();
      echo "</table></p>";
   }
}
?>
