<?php
include "kopfsq3_highscore.inc.php";

class Spiel
{
   function __construct(private $spieler = "", private $start = 0, private $ziel = "",
      private $anzahl = 5, private $richtig = 0, private $aufgabe = array(), private $startzeit = 0)
   {
      $this->startzeit = microtime(true);
   }

   function anzeigen()
   {
      echo "<p><b>Kopfrechnen</b></p>";
      if($this->spieler == "")
      {
         echo "<p>Kein Name, kein Spiel</p>";
         echo "<a href='$this->start'>Zurück</a>";
         return;
      }

      echo "<form action='$this->ziel' method='post'>";
      echo "<p>Hallo <b>$this->spieler</b>, Ihre Aufgaben:</p>";

      echo "<table>";
      for($i=1; $i<=$this->anzahl; $i++)
         $this->aufgabe[$i] = new Aufgabe($i, $this->anzahl);
      echo "</table>";

      echo "<p><input type='submit' value='Fertig'></p>";
      echo "</form>";
   }

   function speichern()
   {
      $zk = serialize($this);
      file_put_contents('kopfsq3.dat', $zk);
   }

   function auswerten($eingabe)
   {
      $endzeit = microtime(true);
      $this->dauer = number_format($endzeit - $this->startzeit, 1, ".", "");

      echo "<p><b>Kopfrechnen</b></p>";
      echo "<p>Hallo <b>$this->spieler</b>, Ihr Ergebnis:</p>";

      for($i=1; $i<=$this->anzahl; $i++)
         $this->richtig += $this->aufgabe[$i]->pruefen(floatval($eingabe[$i]));
      echo "<p>$this->richtig von $this->anzahl richtig in $this->dauer Sek.</p>";

      if($this->richtig == $this->anzahl)
         new Highscore($this->spieler, $this->dauer);
   }
}
?>
