<?php
class Highscore
{
   /* Die Klasse "Highscore" enthält drei Eigenschaften:
      - Name des Spielers,
      - Spieldauer des Spielers und
      - die Referenz auf die Datenbankverbindung */
   function __construct(private $spieler = "", private $dauer = 0, private $con = null)
   {
      /* Verbindung zur Datenbank */
      $this->con = new mysqli("localhost", "root", "", "kopfzeit");

      /* Mithilfe eines Prepared Statements wird ein neuer Datensatz
         mit dem Namen des Spielers und seiner Spieldauer in die Tabelle eingefügt. */
      $sql = "INSERT INTO highscore (name, zeit) VALUES (?, ?)";
      $this->con->execute_query($sql, [$spieler, $dauer]);

      /* Alle Datensätze anzeigen */
      $this->anzeigen();
   }

   function anzeigen()
   {
      echo "<p><b>Highscore:</b></p>";
      echo "<p><table>";
      echo "<tr><td><b>Name</b></td><td><b>Zeit</b></td></tr>";

      /* Abruf und Anzeige der maximal zehn besten Ergebnisse aus der Datenbanktabelle */
      $sql = "SELECT * FROM highscore ORDER BY zeit LIMIT 10";
      $res = $this->con->execute_query($sql);
      while($dsatz = $res->fetch_assoc())
         echo "<tr><td>" . $dsatz["name"] . "</td><td style='text-align:right;'>"
            . number_format($dsatz["zeit"], 1) . " Sek.</td></tr>";
      $res->close();
      echo "</table></p>";
   }

   function __destruct()
   {
      /* Im Destruktor wird die Verbindung zur Datenbank geschlossen. */
      $this->con->close();
   }
}
?>
