<?php
/* Die Datei mit der Definition der neuen Klasse "Highscore" wird eingebunden. */
include "kopfzeit_highscore.inc.php";

class Spiel
{
   /* Am Ende des Konstruktors wird mithilfe der Funktion microtime() die aktuelle Zeit ermittelt.
      Sie wird in der neuen Eigenschaft "startzeit" der Klasse "Spiel" festgehalten. */
   function __construct(private $spieler = "", private $start = "", private $ziel = "",
      private $anzahl = 5, private $richtig = 0, private $aufgabe = array(), private $startzeit = 0)
   {
      $this->startzeit = microtime(true);
   }

   function anzeigen()
   {
      echo "<p><b>Kopfrechnen</b></p>";
      if($this->spieler == "")
      {
         echo "<p>Kein Name, kein Spiel</p>";
         echo "<a href='$this->start'>Zurück</a>";
         return;
      }

      echo "<form action='$this->ziel' method='post'>";
      echo "<p>Hallo <b>$this->spieler</b>, Ihre Aufgaben:</p>";

      echo "<table>";
      for($i=1; $i<=$this->anzahl; $i++)
         $this->aufgabe[$i] = new Aufgabe($i, $this->anzahl);
      echo "</table>";

      echo "<p><input type='submit' value='Fertig'></p>";
      echo "</form>";
   }

   function speichern()
   {
      $zk = serialize($this);
      file_put_contents("kopfzeit.dat", $zk);
   }

   function auswerten($eingabe)
   {
      /* Die aktuelle Zeit wird ermittelt. */
      $endzeit = microtime(true);

      /* Die Spieldauer, also die Zeitdifferenz zwischen Startzeit und Endzeit wird berechnet
         und – gerundet auf eine Stelle nach dem Komma – in der Variablen $dauer gespeichert. */
      $dauer = number_format($endzeit - $this->startzeit, 1, ".", "");

      echo "<p><b>Kopfrechnen</b></p>";
      echo "<p>Hallo <b>$this->spieler</b>, Ihr Ergebnis:</p>";

      for($i=1; $i<=$this->anzahl; $i++)
         $this->richtig += $this->aufgabe[$i]->pruefen(floatval($eingabe[$i]));
      echo "<p>$this->richtig von $this->anzahl richtig in $dauer Sek.</p>";

   
      /* Werden alle Aufgaben richtig gelöst, wird ein neues Objekt der Klasse "Highscore" erzeugt.
         Name und Spieldauer werden übergeben. Den Rest erledigt das Highscore-Objekt. */
      if($this->richtig == $this->anzahl)
         new Highscore($this->spieler, $dauer);
   }
}
?>
