<?php
   session_start();
?>
<!DOCTYPE html>
<html lang="de">
<head>
<!-- Durch den Aufruf der PHP-Funktion session_start() wird das Session-Management gestartet.
     Die Meta-Angabe "http-equiv" steht für ein HTTP-Äquivalent. Diese HTTP-Äquivalente dienen zur Steuerung des Webservers.
     Das HTTP-Äquivalent "refresh" ermöglicht die Weiterleitung an eine Adresse nach einer bestimmten Zeit.
     Im vorliegenden Fall wird nach drei Sekunden an die eigene Adresse weitergeleitet.
     Das Ergebnis: Das Programm ruft sich alle drei Sekunden selbst auf, damit auch auf eine Änderung des
        Spielzustands durch einen anderen Spieler reagiert werden kann. -->
   <meta http-equiv="refresh" content="3; url=index.php">
   <meta charset="utf-8">
   <title>Multiplayer-Spiel</title>
   <style>
      body {font-family:Verdana; font-size:10pt; color:#b22222; background-color:#e3e3e3}
   </style>

<script>
   /* Die JavaScript-Funktion senden() wird entweder durch die Betätigung einer der Schaltflächen oder
      durch den Klick auf eine der Karten aufgerufen.

      Die möglichen Spielzustände und die Werte der zugehörigen Parameter sind wie folgt definiert:
      - Schaltfläche "Anmelden": aktion=0. Der Spieler möchte sich anmelden.
      - Schaltfläche "Abmelden": aktion=1. Der Spieler möchte sich abmelden.
        Der Parameter "wert" kennzeichnet die verschiedenen Situationen:
         - wert=1: Abmeldung nach Ende des Spiels
         - wert=2: Abmeldung vor Beginn des Spiels
         - wert=3: Abmeldung mitten im Spiel
      - Schaltfläche "Hilfe": aktion=2. Der Spieler möchte den Hilfetext sehen.
      - Klick auf Karte: aktion=3. Der Parameter "wert" kennzeichnet den Wert der gelegten Karte, von 1 (Herz Zehn) bis 5 (Herz As).

      Die Werte der Parameter sendet sich das Programm als Formularwerte selbst zu.
      Beim nächsten automatischen Aufruf der Seite werden diese Werte genutzt. */
   function senden(aktion, wert)
   {
      if(aktion == 1)
      {
         if(wert == 2)
         {
            if(!confirm("Vor Beginn des Spiels abmelden?"))
               return;
         }
         else if(wert == 3)
         {
            if(!confirm("Beide vor dem Ende abmelden?"))
               return;
         }
      }

      document.f.aktion.value = aktion;
      document.f.karteGespielt.value = wert;
      document.f.submit();
   }
</script>
<?php
   /* Die Funktion anmelden() wird nach Betätigung der Schaltfläche "Anmelden" aufgerufen. */
   function anmelden()
   {
      /* Mithilfe der Funktion simplexml_load_file() werden zwei PHP-Objekte mit den Inhalten der beiden XML-Dateien angelegt.
         Diese Objekte werden im Verlauf der Funktion gegebenenfalls verändert. */
      $spieler = simplexml_load_file("spieler.xml");
      $wartender = simplexml_load_file("wartender.xml");

      /* Es gibt zwei mögliche Zustände. */

      /* Zustand 1: In der Datei wartender.xml steht noch kein anderer Spieler, der auf die Anmeldung eines Gegners wartet.
         In diesem Fall wird die Session-ID des aktuellen Spielers in die Datei wartender.xml eingetragen.
         Er wird also zum wartenden Spieler, der auf die Anmeldung eines Gegners wartet. */
      if(mb_strlen($wartender->ID) <= 1)
         $wartender->ID = session_id();

      /* Zustand 2: In der Datei wartender.xml steht bereits ein anderer Spieler.
         Das ist der Gegner für den aktuellen Spieler. Die Session-ID des Gegners wird als gegnerische ID eingetragen.
         Die XML-Datei des Gegners wird geöffnet und es wird die eigene ID als Gegner des Gegners eingetragen.
         Anschließend gibt es keinen wartenden Spieler mehr. */
      else
      {
         $spieler->gegnerID = $wartender->ID;
         $gegner = simplexml_load_file("spieler_" . $spieler->gegnerID . ".xml");
         $gegner->gegnerID = session_id();
         file_put_contents("spieler_" . $spieler->gegnerID . ".xml", $gegner->asXML());
         $wartender->ID = " ";
      }

      /* Die beiden PHP-Objekte werden wieder in den zugehörigen XML-Dateien gespeichert. */
      file_put_contents("spieler_" . session_id() . ".xml", $spieler->asXML());
      file_put_contents("wartender.xml", $wartender->asXML());
   }

   /* Die Funktion abmelden() wird nach Betätigung der Schaltfläche "Abmelden" aufgerufen.
      Sie erhält als Parameter die Session-ID des Spielers, der abgemeldet werden soll. */
   function abmelden($id)
   {
      /* Nach dem Abmelden des Spielers soll auch der Gegner abgemeldet werden.
         Zu diesem Zweck ruft sich die Funktion einmal selbst auf.
         Diese Rekursion soll allerdings nach einem Durchlauf enden.
         Der Gegner des Gegners (sprich: der Spieler selbst) soll also nicht erneut abgemeldet werden.
         Zu diesem Zweck wird als Erstes geprüft, ob für den Spieler eine XML-Datei existiert.
         Ist das nicht der Fall, ist der Spieler bereits abgemeldet und die Funktion wird unmittelbar verlassen. */
      if(!file_exists("spieler_" . $id . ".xml"))
         return;

      /* Das Spieler-Objekt wird aus der XML-Datei gefüllt. Diese XML-Datei wird mithilfe der Funktion unlink() gelöscht und
         es wird eine allgemeine Info gespeichert, die im Browserfenster des Spielers angezeigt wird, der soeben abgemeldet wurde. */
      $spieler = simplexml_load_file("spieler_" . $id . ".xml");
      unlink("spieler_" . $id . ".xml");
      $infoAllgemein = "Sie haben sich abgemeldet";

      /* Es gibt zwei mögliche Zustände. */

      /* Zustand 1: Der Spieler ist zurzeit angemeldet und hat einen Gegner.
         Für diesen Gegner ruft sich die Funktion abmelden() selbst auf. */
      if(mb_strlen($spieler->gegnerID) > 1)
         abmelden($spieler->gegnerID);

      /* Zustand 2: Der Spieler ist zurzeit nicht angemeldet und wartet auf einen Gegner.
         In diesem Fall wird der Spieler als Wartender gelöscht. */
      else
      {
         $wartender = simplexml_load_file("wartender.xml");
         $wartender->ID = " ";
         file_put_contents("wartender.xml", $wartender->asXML());
      }
   }

   /* Die Funktion lesen() liest den gespeicherten Wert einer Eigenschaft des Spielers und liefert ihn als Rückgabewert zurück.
      Als Parameter wird der Name der Eigenschaft, also des Attributs, übergeben. */
   function lesen($attr)
   {
      /* Das Spieler-Objekt wird aus der XML-Datei gefüllt. */
      $spieler = simplexml_load_file("spieler_" . session_id() . ".xml");

      /* Der Wert des gewünschten Attributs des Spielers wird als Wert der Funktion zurückgeliefert.
         Alle Attribute außer "info" beinhalten ganze Zahlen.
         Daher wird mithilfe der Funktion intval() der ganzzahlige Wert des Attributs geliefert. */
      if($attr == "info")
         return $spieler->$attr;
      else
         return intval($spieler->$attr);
   }

   /* Die Funktion lesenGegner() liest den gespeicherten Wert einer Eigenschaft des Gegners und liefert ihn als Rückgabewert zurück.
      Als Parameter wird auch hier der Name der Eigenschaft, also des Attributs, übergeben.	  */
   function lesenGegner($attr)
   {
      /* Das Spieler-Objekt und das Gegner-Objekt werden aus der jeweiligen XML-Datei gefüllt. */
      $spieler = simplexml_load_file("spieler_" . session_id() . ".xml");
      $gegner = simplexml_load_file("spieler_" . $spieler->gegnerID . ".xml");

      /* Der Wert des gewünschten Attributs des Gegners wird als Wert der Funktion zurückgeliefert.
         Alle Attribute außer "info" beinhalten ganze Zahlen.
         Daher wird mithilfe der Funktion intval() der ganzzahlige Wert des Attributs geliefert. */
      if($attr == "info")
         return $gegner->$attr;
      else
         return intval($gegner->$attr);
   }

   /* Die Funktion schreiben() überschreibt den gespeicherten Wert eines Attributs des Spielers mit einem neuen Wert.
      Als Parameter wird neben dem Namen des Attributs der neue Wert übergeben. */
   function schreiben($attr, $wert)
   {
      /* Das Spieler-Objekt wird aus der zugehörigen XML-Datei gefüllt. */
      $spieler = simplexml_load_file("spieler_" . session_id() . ".xml");

      /* Das Attribut des Spielers erhält den neuen Wert. */
      $spieler->$attr = $wert;

      /* Das veränderte Objekt wird wieder in der zugehörigen XML-Datei gespeichert. */
      file_put_contents("spieler_" . session_id() . ".xml", $spieler->asXML());
   }

   /* Die Funktion schreibenGegner() überschreibt den gespeicherten Wert eines Attributs des Gegners mit einem neuen Wert.
      Als Parameter wird auch hier neben dem Namen des Attributs der neue Wert übergeben. */
   function schreibenGegner($attr, $wert)
   {
      /* Das Spieler-Objekt und das Gegner-Objekt werden aus den zugehörigen XML-Dateien gefüllt. */
      $spieler = simplexml_load_file("spieler_" . session_id() . ".xml");
      $gegner = simplexml_load_file("spieler_" . $spieler->gegnerID . ".xml");

      /* Das Attribut des Gegners erhält den neuen Wert. */
      $gegner->$attr = $wert;

      /* Das veränderte Objekt wird wieder in der zugehörigen XML-Datei gespeichert. */
      file_put_contents("spieler_" . $spieler->gegnerID . ".xml", $gegner->asXML());
   }

   /* Die Funktion erhoehen() wird aufgerufen, um den gespeicherten Wert einer Eigenschaft des Spielers um 1 zu erhöhen.
      Der Ablauf ähnelt demjenigen der Funktion schreiben(). */
   function erhoehen($attr)
   {
	  $spieler = simplexml_load_file("spieler_" . session_id() . ".xml");
      $spieler->$attr = $spieler->$attr + 1;
      file_put_contents("spieler_" . session_id() . ".xml", $spieler->asXML());
   }

   /* Die Funktion erhoehenGegner() wird aufgerufen, um den gespeicherten Wert einer Eigenschaft des Gegners um 1 zu erhöhen.
      Der Ablauf ähnelt demjenigen der Funktion schreibenGegner(). */
   function erhoehenGegner($attr)
   {
      $spieler = simplexml_load_file("spieler_" . session_id() . ".xml");
      $gegner = simplexml_load_file("spieler_" . $spieler->gegnerID . ".xml");
      $gegner->$attr = $gegner->$attr + 1;
      file_put_contents("spieler_" . $spieler->gegnerID . ".xml", $gegner->asXML());
   }

   /* Löst der Benutzer eine Aktion aus (Betätigung einer Schaltfläche, Klick auf Karte) werden Formulardaten gesendet.
      Die Auswertung dieser Daten erfolgt beim nächsten Aufruf der Seite, wie nachfolgend beschrieben. */
   if(isset($_POST["aktion"]))
   {
      /* Nach dem Betätigen der Schaltfläche "Anmelden" wird die Funktion anmelden() aufgerufen. */
      if($_POST["aktion"] == "0")
         anmelden();

      /* Nach dem Betätigen der Schaltfläche "Abmelden" wird die Funktionen abmelden() aufgerufen.
         Dabei wird die Session-ID des Spielers übergeben. */
      else if($_POST["aktion"] == "1")
         abmelden(session_id());

      /* Nach dem Betätigen der Schaltfläche "Hilfe" wird die Beschreibung des Spiels als Information für diesen Spieler gespeichert.
         Sie wird am Ende des Programms ausgegeben. */
      else if($_POST["aktion"] == "2")
         schreiben("info", "Zwei Spieler müssen sich anmelden. Nach der "
            . "Anmeldung hat jeder Spieler fünf Karten zur Verfügung.<br>In jeder Runde legt jeder Spieler "
            . "eine Karte. Der Spieler mit der höheren Karte erhält einen Punkt.<br>Falls beide Spieler "
            . "dieselbe Karte legen, erhält keiner einen Punkt. Das Spiel ist nach fünf Runden beendet.");

      /* Nach dem Klick auf eine Karte wird zunächst festgestellt, welche Karte gelegt wurde.
         Ihr Wert wird als die letzte gelegte Karte des Spielers gespeichert.
         Die betreffende Karte wird als "gelegt" gekennzeichnet.
         Die Anzahl der Runden dieses Spielers wird um 1 erhöht. */
      else if($_POST["aktion"] == "3")
      {
         $meine = $_POST["karteGespielt"];
         schreiben("karteLetzte", $meine);
         schreiben("karte$meine", 0);
         erhoehen("runde");

         /* Es gibt zwei mögliche Zustände. */

         /* Zustand 1: Der Gegner hat noch keine Karte gelegt und wartet daher nicht auf die Karte des Spielers.
            In diesem Fall wird für den Spieler eingetragen: "Wartet auf Karte des Gegners". */
         if(lesenGegner("warten") == 0)
         {
            schreiben("warten", 1);
            schreiben("info", "");
         }

         /* Zustand 2: Der Gegner hat bereits eine Karte gelegt und wartet auf eine Karte des Spielers.
            In diesem Fall wird für den Gegner eingetragen: "Wartet nicht mehr".
            Die letzte gelegte Karte des Gegners wird ermittelt und mit der letzten gelegten Karte des Spielers verglichen.
            Für Spieler und Gegner wird ein individueller Text zusammengestellt, der am Ende des Programms ausgegeben wird:
               Welche Karten wurden gelegt, wer hatte die höhere Karte und wer erhält einen Punkt?
            Die Punktzahl wird entsprechend erhöht. */
         else
         {
            $karteText[1] = "eine Zehn";
            $karteText[2] = "einen Buben";
            $karteText[3] = "eine Dame";
            $karteText[4] = "einen König";
            $karteText[5] = "ein As";

            schreibenGegner("warten", 0);
            $seine = lesenGegner("karteLetzte");
            $meineInfo = "Du hattest $karteText[$meine], der Gegner hatte $karteText[$seine], ";
            $seineInfo = "Du hattest $karteText[$seine], der Gegner hatte $karteText[$meine], ";

            if($meine > $seine)
            {
               $meineInfo .= "Punkt für Dich";
               $seineInfo .= "Punkt für den Gegner";
               erhoehen("punkte");
            }
            else if($seine > $meine)
            {
               $meineInfo .= "Punkt für den Gegner";
               $seineInfo .= "Punkt für Dich";
               erhoehenGegner("punkte");
            }
            else
            {
               $meineInfo .= "keine Punkte";
               $seineInfo .= "keine Punkte";
            }

            schreiben("info", $meineInfo);
            schreibenGegner("info", $seineInfo);
         }
      }
   }
?>
</head>
<body>
<!-- Die beiden versteckten Formularelemente "aktion" und "karteGespielt" erhalten ihre Werte
     mithilfe der oben beschriebenen JavaScript-Funktion senden(). -->
<form name="f" action="index.php" method="post">
   <input type="hidden" name="aktion">
   <input type="hidden" name="karteGespielt">
<?php
   /* Ist der Spieler noch nicht angemeldet, gibt es noch keine XML-Datei für ihn.
      In diesem Fall wird die Schaltfläche "Anmelden" angezeigt. */
   if(!file_exists("spieler_" . session_id() . ".xml"))
      echo "<p><input type='button' value='Anmelden' onclick='senden(0,0);'>";

   /* Ist der Spieler bereits angemeldet, werden die beiden Schaltflächen "Abmelden" und "Hilfe" angezeigt.
      Nach dem Abmelden gibt es drei mögliche Zustände:
      - Das Spiel ist zu Ende. Das wäre der Standardfall ($status = 1).
      - Der Spieler wartet noch auf einen Gegner ($status = 2).
      - Das Spiel ist noch nicht zu Ende ($status = 3). */
   else
   {
      $status = 1;
      $wartender = simplexml_load_file("wartender.xml");

      if($wartender->ID == session_id())
         $status = 2;
      else
      {
         $runde = lesen("runde");
         $rundeGegner = lesenGegner("runde");
         if($runde < 5 || $rundeGegner < 5)
            $status = 3;
      }

      /* Es werden auch zwei Sonderfälle berücksichtigt:
         - Ein Spieler möchte sich abmelden, während er auf die Anmeldung eines Gegners wartet.
         - Ein Spieler möchte sich mitten im Verlauf eines Spiels abmelden.
         Es erfolgt eine Rückfrage. Nach Bestätigung der Abmeldung befinden sich beide Spieler wieder im Zustand "Anmelden". */
      echo "<p><input type='button' value='Abmelden' onclick='senden(1,$status);'> ";

      /* Nach Betätigung der Schaltfläche "Hilfe" erscheint der folgende Hilfetext mit den Spielregeln:
         Zwei Spieler müssen sich anmelden. Nach der Anmeldung hat jeder Spieler fünf Karten zur Verfügung.
         In jeder Runde legt jeder Spieler eine Karte. Der Spieler mit der höheren Karte erhält einen Punkt.
         Falls beide Spieler dieselbe Karte legen, erhält keiner einen Punkt. Das Spiel ist nach fünf Runden beendet. */
      echo "<input type='button' value='Hilfe' onclick='senden(2,0);'></p>";
   }

   /* Für einen angemeldeten Spieler werden entweder bestimmte Informationen oder der Spielstand und die Spielkarten angezeigt. */
   if(file_exists("spieler_" . session_id() . ".xml"))
   {
      /* Der Spieler wartet darauf, dass sich ein Gegner anmeldet. */
      $wartender = simplexml_load_file("wartender.xml");
      if($wartender->ID == session_id())
         echo "<p>Warte auf Anmeldung eines Gegners</p>";

	  /* Der Spieler wartet auf eine Spielkarte des Gegners. */
      else if(lesen("warten") == 1)
         echo "<p>Warte auf eine Karte des Gegners</p>";

      /* Der Spieler wartet weder auf eine Anmeldung noch auf eine Spielkarte. */
      else
      {
         /* Der Spielstand wird angezeigt. */
         echo "<p>Stand: " . lesen("punkte") . ":" . lesenGegner("punkte");

         /* Vor dem Legen der ersten Karte wird zusätzlich angezeigt, dass es jetzt losgeht. */
         if(lesen("runde") == 0)
            echo ", es geht los";
         echo "</p>";

         /* Es gibt zwei mögliche Zustände. */

         /* Zustand 1: Das Spiel ist noch nicht zu Ende. */
         if(lesen("runde") < 5)
         {
            /* Es wird eine Tabelle mit fünf Kartenbildern angezeigt. */
            echo "<p><table><tr>";
            for($i=1; $i<=5; $i++)
            {
               /* Wurde eine Karte noch nicht gelegt, wird sie angezeigt und kann angeklickt werden.
                  Dank der CSS-Style-Angabe border:0px ist kein Rahmen für den Hyperlink sichtbar. */
               if(lesen("karte$i") == 1)
                  echo "<td><a href='javascript:senden(3,$i);'><img src='bilder/karteBild$i.png' alt='[Bild]' style='border:0px;'></a></td>";

               /* Wurde eine Karte bereits gelegt, wird die Rückseite angezeigt. */
               else
                  echo "<td><img src='bilder/rueckseite.png' alt='[Bild]'></td>";
            }
            echo "</tr></table></p>";
         }

         /* Zustand 2: Das Spiel ist zu Ende. */
         else
         {
            schreiben("info", "");
            schreibenGegner("info", "");

            /* Die Punkte beider Spieler werden ermittelt.
               Das resultierende Ergebnis wird angezeigt. */
            if(lesen("punkte") > lesenGegner("punkte"))
               echo "<p>Sie haben gewonnen!";
            else if(lesenGegner("punkte") > lesen("punkte"))
               echo "<p>Sie haben leider verloren.";
            else
               echo "<p>Es gab ein Unentschieden.";
            echo " Bitte melden Sie sich ab.</p>";
         }
      }
   }

   /* Sind persönliche Informationen für einen Spieler in seiner XML-Datei zwischengespeichert, werden diese angezeigt. */
   if(file_exists("spieler_" . session_id() . ".xml"))
   {
      $infoPersoenlich = lesen("info");
      if($infoPersoenlich != "")
         echo "<p>$infoPersoenlich</p>";
   }

   /* Für einen Spieler, der noch nicht oder nicht mehr angemeldet ist, können keine persönlichen Informationen in einer
      XML-Datei gespeichert werden. In diesem Fall werden für ihn allgemeine Informationen in einer Variablen gespeichert.
      Diese werden ebenfalls angezeigt.*/
   if(isset($infoAllgemein))
      echo "<p>$infoAllgemein</p>";
?>
</form>
</body>
</html>
