<!DOCTYPE html>
<html lang="de">
<head>
   <meta charset="utf-8">
   <title>Objekte und Felder</title>
</head>
<body>
<?php
class Bestellung
{
   function __construct(private $bestellnummer = 0,
      private $postenfeld = array()) { }

   function __toString()
   {
      $gesamt = 0;
      $ausgabe = "Bestellnr.: $this->bestellnummer<br>";
      for($i=0; $i<count($this->postenfeld); $i++)
      {
         $ausgabe .= "Posten " . ($i+1) . ": " . $this->postenfeld[$i] . "<br>";
         $gesamt += $this->postenfeld[$i]->postenpreis();
      }
      $ausgabe .= "Gesamtpreis: $gesamt €<br>";
      return $ausgabe;
   }
}

class Bestellposten
{
   function __construct(private $artikelname = "unbekannt",
      private $anzahl = 0, private $preis = 0.0) { }

   function postenpreis()
   {
      return $this->anzahl * $this->preis;
   }

   function __toString()
   {
      return "$this->artikelname, $this->anzahl St., $this->preis €";
   }
}

/* Hauptprogramm */
$meineBestellung = new Bestellung(583,
   array(new Bestellposten("Apfel", 3, 1.35),
         new Bestellposten("Banane", 5, 0.85),
         new Bestellposten("Mango", 2, 1.95)));
echo $meineBestellung;
?>
</body>
</html>
