<!DOCTYPE html>
<html lang="de">
<head>
   <meta charset="utf-8">
   <title>Parameter</title>
</head>
<body>
<?php
/* Definition der Klasse Fahrzeug */
class Fahrzeug
{
   /* Konstruktor mit optionalen Parametern */
   function __construct(private $bezeichnung = "unbekannt",
      private $geschwindigkeit = 0) { }

   function beschleunigen($wert)
   {
      $this->geschwindigkeit += $wert;
   }

   function __toString()
   {
      return "$this->bezeichnung, $this->geschwindigkeit km/h<br>";
   }
}

/* Mit positionalen Parametern erzeugen */
$jeep = new Fahrzeug("Jeep Cherokee",45);
$vespa = new Fahrzeug("Vespa Piaggio");

/* Ohne Parameter */
$hyundai = new Fahrzeug();

/* Mit benannten Parametern erzeugen */
$scania = new Fahrzeug(geschwindigkeit: 62);
$seat = new Fahrzeug(geschwindigkeit: 178, bezeichnung: "Seat Leon");

/* Objekte betrachten */
echo $jeep;
echo $vespa;
echo $hyundai;
echo $scania;
echo $seat;
?>
</body>
</html>
