﻿<?php
/* Definition der Klasse "Mitarbeiter", in der die Eigenschaften und Methoden
   eines einzelnen Mitarbeiters definiert werden. */
class Mitarbeiter
{
   /* Ein Mitarbeiter wird durch eine eindeutige ID gekennzeichnet.
      Er hat einen Namen und einen Vornamen, und es gibt Daten zur Bankverbindung.
      Er erhält außerdem einen bestimmten Stundenlohn und hat eine gewisse Anzahl an Stunden gearbeitet. */
   function __construct(private $id = 0, private $nachname = "",
      private $vorname = "", private $bank = "",
      private $iban = "", private $bic = "",
      private $stundenlohn = 0.0, private $summeStunden = 0) { }

   /* Die Methode stundenErfassen() dient dazu, die geleisteten Arbeitsstunden zu summieren. */
   function stundenErfassen($anzahl)
   {
      $this->summeStunden += $anzahl;
   }

   /*  Die Methode scheckAusdruck() dient dazu, aus den Daten eines Mitarbeiters
       und den gesammelten Stunden den Gesamtlohn zu ermitteln und einen Lohnscheck auszugeben. */
   function scheckAusdruck()
   {
      $summeLohn = $this->summeStunden * $this->stundenlohn;
      echo "<p>Scheck:<br>"
        . "Name: $this->nachname, $this->vorname<br>"
        . "IBAN: $this->iban, BIC: $this->bic<br>"
        . "Bank: $this->bank, Betrag: $summeLohn €</p>";
   }
}
?>
