﻿<?php
/* Definition der Klasse "Unternehmen, in der die Eigenschaften und Methoden eines Unternehmens definiert werden.
   Eine der Eigenschaften eines Objekts dieser Klasse ist ein Feld von Objekten der Klasse "Mitarbeiter". */
class Unternehmen
{
   /* Ein Unternehmen wird durch seinen Namen identifiziert, und es verfügt über eine Belegschaft (eine Gruppe von Mitarbeitern).
      Außerdem können die Stunden gesammelt werden, die nicht eindeutig einem Mitarbeiter zuzuordnen sind. */
   function __construct(private $name = "",
      private $belegschaft = array(),
      private $summeStundenUnbekannt = 0)
   {
      /* Im Konstruktor werden die Daten des Unternehmens initialisiert, indem unter anderem die Datei oop_scheck_belegschaft.txt gelesen wird.
         Jede Zeile der Datei enthält die Daten eines Mitarbeiters. Die einzelnen Daten sind durch Kommata voneinander getrennt. */
      $datei = "oop_scheck_belegschaft.txt";

      /* Die Funktion file() liest die gesamte Textdatei und speichert sie in einem Feld von Zeichenketten.
         Mehr zu Dateifunktionen finden Sie in Kapitel 7.*/
      $feld_datei = @file($datei, FILE_IGNORE_NEW_LINES);
      for($i=0; $i<count($feld_datei); $i++)
      {
         /* Die Funktion mb_split() zerlegt eine Zeichenkette anhand eines Trennzeichens (hier: Komma) in einzelne Teile,
            die in einem Feld gespeichert werden. Mehr zu Zeichenkettenfunktionen finden Sie in Kapitel 6. */
         $feld_zeile = mb_split(",", $feld_datei[$i]);

         /* Das erste Feldelement ist die eindeutige ID des Mitarbeiters. Es wird ein Objekt der Klasse "Mitarbeiter" erzeugt.
            Dabei werden die einzelnen Feldelemente mit den Daten dieses Mitarbeiters an den Konstruktor der Klasse "Mitarbeiter" übergeben.
            Zahlenwerte werden dabei zuvor mithilfe der Funktionen intval() und floatval() umgewandelt. */
         $id = intval($feld_zeile[0]);
         $this->belegschaft[$id] = new Mitarbeiter($id, $feld_zeile[1],
            $feld_zeile[2], $feld_zeile[3], $feld_zeile[4], $feld_zeile[5],
            floatval($feld_zeile[6]));
      }
   }

   /* In der Methode stundenErfassen() werden die Informationen aus der Datei oop_scheck_stunden.txt gelesen. */
   function stundenErfassen()
   {
      $datei = "oop_scheck_stunden.txt";
      $feld_datei = @file($datei, FILE_IGNORE_NEW_LINES);
      for($i=0; $i<count($feld_datei); $i++)
      {
         $feld_zeile = mb_split(",", $feld_datei[$i]);
         /* Die Datei enthält eine Reihe von Zeilen mit jeweils zwei Einträgen:
               ID des Mitarbeiters
               Anzahl der Stunden, die von diesem Mitarbeiter an einem Tag geleistet werden. */
         $id = intval($feld_zeile[0]);
         $anzahl = intval($feld_zeile[1]);

         /* Handelt es sich um eine bekannte ID, werden die Stunden dem jeweiligen Mitarbeiter gutgeschrieben.
            Ansonsten werden sie zu summeStundenUnbekannt addiert. */
         if(array_key_exists($id, $this->belegschaft))
            $this->belegschaft[$id]->stundenErfassen($anzahl);
         else
            $this->summeStundenUnbekannt += $anzahl;
      }
   }

   /* Die Methode scheckAusdruck() der Klasse "Unternehmen" ruft die gleichnamige Methode für alle Mitarbeiter des Unternehmens auf. */
   function scheckAusdruck()
   {
      foreach ($this->belegschaft as $schluessel=>$wert)
         $this->belegschaft[$schluessel]->scheckAusdruck();
   }
}
?>
