<?php declare(strict_types=1); ?>
<!DOCTYPE html>
<html lang="de">
<head>
   <meta charset="utf-8">
   <title>Typhinweise</title>
</head>
<body>
<?php
class Fahrzeug
{
   function __construct(private $bezeichnung = "unbekannt",
      private $geschwindigkeit = 0) { }

   function __toString()
   {
      return "$this->bezeichnung, "
         . "$this->geschwindigkeit km/h<br>";
   }

   static function kopieVon(Fahrzeug $ori):Fahrzeug
   {
      $neu = new Fahrzeug();
      $neu->bezeichnung = "Kopie von: " . $ori->bezeichnung;
      $neu->geschwindigkeit = $ori->geschwindigkeit + 1;
      return $neu;
   }
}

$vespa = new Fahrzeug("Vespa Piaggio", 25);
$honda = Fahrzeug::kopieVon($vespa);
echo $honda;
?>
</body>
</html>
