<!DOCTYPE html>
<html lang="de">
<head>
   <meta charset="utf-8">
   <title>Vererbung</title>
</head>
<body>
<?php
class Fahrzeug
{
   function __construct(private $geschwindigkeit = 0) { }

   function beschleunigen($wert)
   {
      $this->geschwindigkeit += $wert;
   }

   function __toString()
   {
      return "$this->geschwindigkeit km/h<br>";
   }
}

class Pkw extends Fahrzeug
{
   function __construct(private $geschwindigkeit = 0,
      private $insassen = 0)
   {
      parent::__construct($geschwindigkeit);
   }

   function einsteigen($anzahl)
   {
      $this->insassen += $anzahl;
   }

   function aussteigen($anzahl)
   {
      $this->insassen -= $anzahl;
   }

   function __toString()
   {
      return "$this->insassen Insassen, " . parent::__toString();
   }
}

$fiat = new Pkw();
echo $fiat;

$fiat->einsteigen(3);
$fiat->beschleunigen(30);
echo $fiat;

$fiat->beschleunigen(-30);
echo $fiat;

$fiat->aussteigen(1);
echo $fiat;
?>
</body>
</html>
