<!DOCTYPE html>
<html lang="de">
<head>
   <meta charset="utf-8">
   <title>Pizzabestellung, Auswertung</title>
</head>
<body>
<?php
   /* Ermittlung des Grundpreises aus dem Typ der Pizza
      mithilfe eines match-Ausdrucks */
   $preis = match($_POST["pizzatyp"])
   {
      "Napoli" => 5.7,
      "Italia" => 6.3,
      "Con Tutto" => 7.1,
      "4 Stagioni" => 6.6,
      "Mozzarella" => 7.8,
      default => 0.0
   };

   /* Auswahl der Anrede,
      Beginn der Ausgabe mit Bestätigung des Typs der Pizza */
   $besteller = htmlentities($_POST["besteller"]);
   if($_POST["anrede"] == "Herr")
      echo "<p>Sehr geehrter Herr $besteller</p>";
   else
      echo "<p>Sehr geehrte Frau $besteller</p>";
   echo "<p>Wir liefern Ihre Pizza " . $_POST["pizzatyp"];

   /* Ist einer der Zusätze gewählt, wird dies ebenfalls bestätigt.
      Außerdem erhöht sich der Preis. */
   if(isset($_POST["thunfisch"]))
   {
      echo ", mit extra Thunfisch";
      $preis = $preis + 0.6;
   }
   if(isset($_POST["salami"]))
   {
      echo ", mit extra Salami";
      $preis = $preis + 1.1;
   }

   /* Die Adresse wird zusammen mit dem Gesamtpreis ausgegeben. */
   echo "<br>in 20 Minuten an die folgende Adresse:<br>";
   echo nl2br(htmlentities($_POST["adresse"])) . "</p>";
   echo "<p>Preis: " . number_format($preis,2,",",".") . " €</p>";
   echo "<p>Ihr Pizza-Team</p>";
?>
</body>
</html>
