<?php
   function int_positiv($bereich, $text, &$zahl)
   {
      if(!is_numeric($text))
      {
         echo "<p style='color:#ff0000;'>$bereich: Zahl eintragen</p>";
         return false;
      }

      if($text == "0")
      {
         $zahl = 0;
         return true;
      }
      
      $zahl = intval($text);
      if($zahl < 0)
      {
         echo "<p style='color:#ff0000;'>"
            . "$bereich: Ganze Zahl >= 0 eintragen</p>";
         return false;
      }
      else
         return true;
   }

   function float_positiv($bereich, $text, &$zahl)
   {
      if(!is_numeric($text))
      {
         echo "<p style='color:#ff0000;'>$bereich: Zahl eintragen</p>";
         return false;
      }

      if($text == "0" || $text == "0.0")
      {
         $zahl = 0.0;
         return true;
      }
      
      $zahl = floatval($text);
      if($zahl <= 0)
      {
         echo "<p style='color:#ff0000;'>$bereich: Zahl >= 0 eintragen</p>";
         return false;
      }
      else
         return true;
   }

   function pk_neu_doppelt($bereich, $pk, $con, $tab, $feld)
   {
      $sql = "SELECT * FROM $tab WHERE $feld = ?";
      $res = $con->execute_query($sql, [$pk]);
      $anzahl = $res->num_rows;
      $res->close();

      if($anzahl > 0)
      {
         echo "<p style='color:#ff0000;'>$bereich: Bereits vorhanden</p>";
         return true;
      }
      else
         return false;
   }
   
   function pk_aendern_doppelt($bereich, $pk, $ori, $con, $tab, $feld)
   {
      $sql = "SELECT * FROM $tab WHERE $feld = ? AND $feld <> '$ori'";
      $res = $con->execute_query($sql, [$pk]);
      $anzahl = $res->num_rows;
      $res->close();

      if($anzahl > 0)
      {
         echo "<p style='color:#ff0000;'>$bereich: Bereits vorhanden</p>";
         return true;
      }
      else
         return false;
   }
   
   function datum_gueltig($bereich, $datum, &$gt)
   {
      $feld = mb_split("\.", $datum);
      if(count($feld) != 3)
      {
         echo "<p style='color:#ff0000;'>"
            . "$bereich: Datum in T.M.JJJJ eintragen</p>";
         return false;
      }

      if(!is_numeric($feld[0]) || !is_numeric($feld[1])
         || !is_numeric($feld[2]))
      {
         echo "<p style='color:#ff0000;'>"
            . "$bereich: Zahlen für Tag, Monat und Jahr eintragen</p>";
         return false;
      }

      $tag = intval($feld[0]);
      $monat = intval($feld[1]);
      $jahr = intval($feld[2]);
      if(checkdate($monat, $tag, $jahr))
      {
         $gt = $jahr . "-" . $monat . "-" . $tag;
         return true;
      }
      else
      {
         echo "<p style='color:#ff0000;'>"
            . "$bereich: Gültiges Datum eintragen</p>";
         return false;
      }
   }
?>

