<!DOCTYPE html>
<html lang="de">
<head>
   <meta charset="utf-8">
   <title>SQLite3, Hyperlinks und CSS</title>
   <link rel="stylesheet" type="text/css" href="sq3_linkcss.css">

<script type="text/javascript">
function send(aktion,id)
{
   if(aktion==2)
      if(!confirm("Datensatz mit id " + id + " entfernen?"))
         return;

   document.f.aktion.value = aktion;
   document.f.id.value = id;
   document.f.submit();
}
</script>
</head>

<body>
<?php
   /* Datenbankdatei öffnen */
   $db = new SQLite3("sq3.db");

   /* Sortierung, wird ggf. überschrieben */
   $od = " ORDER BY personalnummer";

   /* Aktion ausführen */
   if(isset($_POST["aktion"]))
   {
      /* neu eintragen */
      if($_POST["aktion"] == "0")
      {
         $ps = $db->prepare("INSERT INTO personen"
           . "(name, vorname, personalnummer, gehalt, geburtstag)"
           . " VALUES(@na, @vo, @pn, @gh, @gb)");
         $ps->bindParam("@na", $_POST["na"][0], SQLITE3_TEXT);
         $ps->bindParam("@vo", $_POST["vo"][0], SQLITE3_TEXT);
         $ps->bindParam("@pn", $_POST["pn"][0], SQLITE3_INTEGER);
         $ps->bindParam("@gh", $_POST["gh"][0], SQLITE3_FLOAT);
         $ps->bindParam("@gb", $_POST["gb"][0], SQLITE3_TEXT);
         $ps->execute();
      }

      /* ändern */
      else if($_POST["aktion"] == "1")
      {
         $id = $_POST["id"];
         $ps = $db->prepare("UPDATE personen SET name=@na,"
            . " vorname=@vo, personalnummer=@pn, gehalt=@gh,"
            . " geburtstag=@gb WHERE personalnummer=$id");
         $ps->bindParam("@na", $_POST["na"][$id], SQLITE3_TEXT);
         $ps->bindParam("@vo", $_POST["vo"][$id], SQLITE3_TEXT);
         $ps->bindParam("@pn", $_POST["pn"][$id], SQLITE3_INTEGER);
         $ps->bindParam("@gh", $_POST["gh"][$id], SQLITE3_FLOAT);
         $ps->bindParam("@gb", $_POST["gb"][$id], SQLITE3_TEXT);
         $ps->execute();
      }

      /* löschen */
      else if($_POST["aktion"] == "2")
      {
         $ps = $db->prepare("DELETE FROM personen"
            . " WHERE personalnummer = " . $_POST["id"]);
         $ps->execute();
      }

      /* sortieren */
      else if($_POST["aktion"] == "3") $od = " ORDER BY name";
      else if($_POST["aktion"] == "4") $od = " ORDER BY vorname";
      else if($_POST["aktion"] == "5") $od = " ORDER BY personalnummer";
      else if($_POST["aktion"] == "6") $od = " ORDER BY gehalt";
      else if($_POST["aktion"] == "7") $od = " ORDER BY geburtstag";
   }

   /* Formularbeginn */
   echo "<form name='f' action='sq3_linkcss.php' method='post'>"
      . "<input name='aktion' type='hidden'>"
      . "<input name='id' type='hidden'>\n\n";

   /* Tabellenbeginn */
   echo "<table><tr>"
      . "<td><a href='javascript:send(3,0);'>Name</a></td>"
      . "<td><a href='javascript:send(4,0);'>Vorname</a></td>"
      . "<td><a href='javascript:send(5,0);'>P-Nr</a></td>"
      . "<td><a href='javascript:send(6,0);'>Gehalt</a></td>"
      . "<td><a href='javascript:send(7,0);'>Geburtstag</a></td>"
      . "<td>Aktion</td></tr>\n\n";

   /* Neuer Eintrag */
   echo "<tr>"
      . "<td><input name='na[0]' size='6'></td>"
      . "<td><input name='vo[0]' size='6'></td>"
      . "<td><input name='pn[0]' size='6'></td>"
      . "<td><input name='gh[0]' size='6'></td>"
      . "<td><input name='gb[0]' size='10'></td>"
      . "<td><a href='javascript:send(0,0);'>neu eintragen</a></td>"
      . "</tr>\n\n";

   /* Alle vorhandenen Datensätze anzeigen */
   $ps = $db->prepare("SELECT * FROM personen $od");
   $res = $ps->execute();

   while($dsatz = $res->fetchArray())
   {
      $id = $dsatz["personalnummer"];
      $na = $dsatz["name"];
      $vo = $dsatz["vorname"];
      $pn = $dsatz["personalnummer"];
      $gh = $dsatz["gehalt"];
      $gb = $dsatz["geburtstag"];
      echo "<tr>"
         . "<td><input name='na[$id]' value='$na' size='6'></td>"
         . "<td><input name='vo[$id]' value='$vo' size='6'></td>"
         . "<td><input name='pn[$id]' value='$pn' size='6'></td>"
         . "<td><input name='gh[$id]' value='$gh' size='6'></td>"
         . "<td><input name='gb[$id]' value='$gb' size='10'></td>"
         . "<td><a href='javascript:send(1,$id);'>speichern</a>"
         . " <a href='javascript:send(2,$id);'>entfernen</a></td>"
         . "</tr>\n\n";
   }
   echo "</table></form>";
   $db->close();
?>
</body>
</html>
