<!DOCTYPE html>
<html lang="de">
<head>
   <meta charset="utf-8">
   <title>Dekodieren</title>
</head>
<body>
<?php
   /* Mithilfe dieses Programms in der Datei dekodieren.php wird die Lastdatei aus der Bilddatei rekonstruiert.
      Die Breite und die Höhe des Bilds in der Bilddatei in Pixeln werden ermittelt.
      Diese Informationen werden später für den Zugriff auf die einzelnen Pixel des Bilds benötigt. */
   $bildDatei = "bild_neu.png";
   $bildInfo = getimagesize($bildDatei);
   $bildBreite = $bildInfo[0]; 
   $bildHoehe = $bildInfo[1]; 

   /* Der Inhalt der Bilddatei wird in einer Zeichenkette gespeichert.
      Aus dieser Zeichenkette wird mithilfe der Funktion imagecreatefromstring() ein Image-Objekt erzeugt. */
   $img = imagecreatefromstring(file_get_contents($bildDatei));

   /* Es werden einige Variablen initialisiert, die später gefüllt werden:
      - In $lastGroesse wird Byte für Byte die dekodierte Größe der Lastdatei ermittelt.
      - In $lastString wird Byte für Byte der dekodierte Inhalt der Lastdatei zusammengesetzt.
      - Die Variable $ende wird benötigt, um die doppelte Schleife nach dem letzten Byte der Lastdatei zu verlassen. */
   $lastGroesse = 0;
   $lastString = "";
   $ende = false;

   /* Mithilfe einer doppelten Schleife wird auf die einzelnen Pixel des Bilds zugegriffen. */
   for($x=0; $x<$bildBreite; $x++)
   {
      for($y=0; $y<$bildHoehe; $y++)
      {
         /* Die Farbkombination eines Pixels im Bild wird ermittelt. */
         $bildFarbe = imagecolorat($img, $x, $y);

         /* Nach der bitweisen Und-Verknüpfung mit 0x030707 bleiben nur noch die Werte
            derjenigen Bits erhalten, die die Lastinformation beinhalten. */
         $lastFarbe = $bildFarbe & 0x030707;

         /* Die ersten zwei Bits des Bytes der Lastdatei werden aus dem Rot-Anteil des Pixels ermittelt.
            Zu diesem Zweck werden die Bits des Pixels um 16 Bit nach rechts verschoben.
            Anschließend werden sie um sechs Bit nach links verschoben. */
         $rot = ($lastFarbe >> 16) << 6;

         /* Die nächsten drei Bits des Bytes der Lastdatei werden aus dem Grün-Anteil des Pixels ermittelt.
            Zu diesem Zweck werden die Bits des Pixels um acht Bit nach rechts verschoben.
            Nach der bitweisen Und-Verknüpfung mit 0x07 verbleiben nur noch die drei letzten Bits.
            Diese werden um drei Bit nach links verschoben. */
         $gruen = (($lastFarbe >> 8) & 0x07) << 3;

         /* Die letzten drei Bits des Bytes der Lastdatei werden aus dem Blau-Anteil des Pixels ermittelt.
            Nach der bitweisen Und-Verknüpfung mit 0x07 verbleiben nur noch die drei letzten Bit. */
         $blau = $lastFarbe & 0x07;

         /* Das Byte der Lastdatei wird durch eine bitweise Oder-Verknüpfung der drei zuvor gewonnenen Anteile
            ermittelt und in der Variablen $zahl gespeichert. */
         $zahl = $rot | $gruen | $blau;

         /* Der Index des Bytes der Lastdatei wird mithilfe der beiden Schleifenvariablen ermittelt. */
         $index = $x * $bildHoehe + $y;

         /* Aus den ersten vier Bytes wird die Größe der Lastdatei rekonstruiert. */
         if($index < 4)
         {
            /* Dazu wird das erste Byte um 24 Bits, das zweite Byte um 16 Bits und das dritte Byte um acht Bits verschoben. */
            $zahl = $zahl << ((3-$index)*8);

            /* Durch eine bitweise Oder-Verknüpfung wird die Zahl zusammengesetzt, die die Größe der Lastdatei repräsentiert. */
            $lastGroesse = $lastGroesse | $zahl;
         }
         else
         {
            /* Aus den restlichen Bytes wird mithilfe der Funktion chr() jeweils ein Zeichen ermittelt.
               Zeichen für Zeichen wird damit die Zeichenkette zusammengesetzt, aus der später die Lastdatei erzeugt wird. */
            $lastString .= chr($zahl);

            /* Entspricht der Index der zuvor ermittelten Größe der Lastdatei, ist das Ende der Lastdatei erreicht
               und die innere Schleife wird verlassen. */
            if($index > $lastGroesse + 2)
            {
               $ende = true;
               break;
            }
         }
      }

      /* Nachdem das Ende der Lastdatei erreicht ist, wird auch die äußere Schleife verlassen. */
      if($ende)
         break;
   }

   /* Die Lastdatei wird aus der Zeichenkette rekonstruiert. */
   file_put_contents("beispiel_neu.pdf", $lastString);
?>
</body>
</html>
