<!DOCTYPE html>
<html lang="de">
<head>
   <meta charset="utf-8">
   <title>Steuertabelle, Auswertung</title>
</head>
<body>
<h2>Steuertabelle</h2>

<table>
<tr>
   <td><b>Einkommen</b></td>
   <td><b>Steuersatz</b></td>
   <td><b>Steuerbetrag</b></td>
   <td><b>Einkommen nach Steuer</b></td>
</tr>

<?php
/* Umwandlung der Eingaben in Fließkommawerte */
$start     = floatval($_POST["start"]);
$ende      = floatval($_POST["ende"]);
$intervall = floatval($_POST["intervall"]);

/* Für jeden Wert des Einkommens gibt es einen Durchlauf der for-Schleife. */
for($einkommen = $start; $einkommen <= $ende; $einkommen = $einkommen + $intervall)
{
   /* Mehrfache Verzweigung zur Ermittlung des Steuersatzes
      in Abhängigkeit des Einkommens */
   if($einkommen <= 12000)        $satz = 12;
   else if($einkommen <= 20000)   $satz = 15;
   else if($einkommen <= 30000)   $satz = 20;
   else                           $satz = 25;

   /* In Abhängigkeit des Steuersatzes werden der Steuerbetrag
      und das Einkommen nach Abzug der Steuer berechnet. */
   $steuerbetrag = $einkommen * $satz / 100;
   $nachSteuer = $einkommen - $steuerbetrag;

   /* Alle vier Informationen werden formatiert und ausgegeben.
      Die Ausgabe erfolgt in einer Tabelle mit vier Spalten:
      Einkommen in €, Steuersatz in Prozent, Steuerbetrag in € und Einkommen nach Steuer in € */
   echo "<tr>";
   echo "<td style='text-align:right;'>"
      . number_format($einkommen,2,",",".") . " €</td>";
   echo "<td style='text-align:right;'>"
      . number_format($satz,1,",",".") . " %</td>";
   echo "<td style='text-align:right;'>"
      . number_format($steuerbetrag,2,",",".") . " €</td>";
   echo "<td style='text-align:right;'>"
      . number_format($nachSteuer,2,",",".") . " €</td>";
   echo "</tr>";
}
?>

</table>
</body></html>
