<!DOCTYPE html>
<html lang="de">
<head>
   <meta charset="utf-8">
   <title>Eingabe von Datensätzen</title>
<?php
   include "pruefen.inc.php";

   if (isset($_POST["gesendet"]))
   {
      $con = new mysqli("localhost", "root", "", "hardware");
      $fehler = false;

      // GB prüfen
      if(!int_positiv("GB", $_POST["gb"], $gb))
         $fehler = true;

      // Preis prüfen
      if(!float_positiv("Preis", $_POST["preis"], $preis))
         $fehler = true;

      // Artikelnummer prüfen
      if(pk_neu_doppelt("Artikelnummer", $_POST["artnummer"], $con, "fp", "artnummer"))
         $fehler = true;
      
      // Produktionsdatum prüfen
      if(!datum_gueltig("Produktionsdatum", $_POST["prod"], $prod))
         $fehler = true;

      // Alles richtig: Datensatz eintragen
      if(!$fehler)
      {
         echo "Datensatz eingetragen<br>";
         $sql = "INSERT INTO fp(hersteller, typ, gb, preis, artnummer, prod)"
            . "VALUES(?, ?, ?, ?, ?, ?)";
         $con->execute_query($sql, [$_POST["hersteller"],
            $_POST["typ"], $gb, $preis, $_POST["artnummer"], $prod]);
      }
      else
         echo "Kein Datensatz eingetragen<br>";

      $con->close();
   }
?>
</head>
<body>
<p>Geben Sie bitte einen Datensatz ein<br>
und senden Sie das Formular ab:</p>
<form action = "u_db_erzeugen.php" method = "post">
   <p><input name="hersteller"> Hersteller</p>
   <p><input name="typ"> Typ</p>
   <p><input name="gb"> GB</p>
   <p><input name="preis"> Preis (Nachkommastellen mit Punkt)</p>
   <p><input name="artnummer"> Artikelnummer</p>
   <p><input name="prod"> Datum der ersten Produktion (in der Form T.M.JJJJ)</p>
   <p><input type="submit" name="gesendet">
   <input type="reset"></p>
</form>

<p>Alle <a href="u_db_anzeigen.php">anzeigen</a></p>
</body></html>

