<!DOCTYPE html>
<html lang="de">
<head>
   <meta charset="utf-8">
   <title>Mathematische Tabelle</title>
   <style>
      table,td {border:1px solid black;}
      td       {text-align:right;}
   </style>
</head>
<body>

<table>
<tr>
   <td>x</td>
   <td>radiant</td>
   <td>sin</td>
   <td>cos</td>
   <td>&radic;x</td>
   <td>x<sup>2</sup></td>
   <td>log</td>
   <td>log<sub>10</sub></td>
   <td>e<sup>1/x</sup></td>
   <td>dual</td>
   <td>hex</td>
</tr>

<?php
for ($x=15; $x<91; $x+=15)
{
   $xb    = deg2rad($x);
   $xbaus = number_format(     $xb, 2, ",", ".");
   $sinus = number_format(sin($xb), 2, ",", ".");
   $cos   = number_format(cos($xb), 2, ",", ".");
   $wurz  = number_format(sqrt($x), 2, ",", ".");
   $quad  = pow($x,2);
   $logn  = number_format(  log($x), 2, ",", ".");
   $log10 = number_format(log10($x), 2, ",", ".");
   $ehoch = number_format(exp(1/$x), 2, ",", ".");
   $bin   = decbin($x);
   $hexa  = dechex($x);

   echo "<td>$x</td>";
   echo "<td>$xbaus</td>";
   echo "<td>$sinus</td>";
   echo "<td>$cos</td>";
   echo "<td>$wurz</td>";
   echo "<td>$quad</td>";
   echo "<td>$logn</td>";
   echo "<td>$log10</td>";
   echo "<td>$ehoch</td>";
   echo "<td>$bin</td>";
   echo "<td>$hexa</td>";
   echo "</tr>";
}
?>
</table>
</body>
</html>
