<!DOCTYPE html>
<html lang="de">
<head>
   <meta charset="utf-8">
   <title>Feiertage, Ausgabe</title>
   <style>
      table,td {border:1px solid black;}
   </style>
</head>

<body>
<?php
   /* Die Datei zeit_feiertag.inc.php wird eingebunden.
      Darin stehen die bereits bekannte Funktion ostersonntag() und die Funktion feiertagNRW(), Kommentare siehe dort. */
   include "zeit_feiertag.inc.php";
   $jahr = intval($_POST["jahr"]);
   echo "<h2>Feiertage in NRW $jahr</h2>";

   /* Die Funktion feiertagNRW() benutzt intern die Funktion ostersonntag() und
         liefert ein assoziatives Feld mit den Namen und Daten aller Feiertage zurück.
      Das Feld ist nach Daten aufsteigend sortiert.
      Die Daten werden in Form von Timestamps geliefert. */
   feiertagNRW($jahr, $ftag);

   /* Das assoziative Feld wird innerhalb einer foreach-Schleife formatiert in einer Tabelle ausgegeben. */
   echo "<table>";
   foreach($ftag as $name=>$wert)
   {
      $datum = date("d.m.Y", $wert);
      echo "<tr><td>$datum</td><td>$name</td></tr>";
   }
   echo "</table>";
?>
</body>
</html>
